/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.tree.IElementType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordList;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;

public class JsonGherkinKeywordProvider
implements GherkinKeywordProvider {
    private static final Logger LOG = Logger.getInstance((String)JsonGherkinKeywordProvider.class.getName());
    private final GherkinKeywordList myEmptyKeywordList = new GherkinKeywordList();
    private final Map<String, GherkinKeywordList> myLanguageKeywords = new HashMap<String, GherkinKeywordList>();
    private final Set<String> myAllStepKeywords = new HashSet<String>();
    private static GherkinKeywordProvider myKeywordProvider;

    public static GherkinKeywordProvider getKeywordProvider() {
        if (myKeywordProvider == null) {
            InputStream inputStream;
            ClassLoader classLoader = JsonGherkinKeywordProvider.class.getClassLoader();
            if (classLoader != null && (inputStream = classLoader.getResourceAsStream("i18n.json")) != null) {
                myKeywordProvider = new JsonGherkinKeywordProvider(inputStream);
            }
            if (myKeywordProvider == null) {
                myKeywordProvider = new PlainGherkinKeywordProvider();
            }
        }
        return myKeywordProvider;
    }

    public JsonGherkinKeywordProvider(File keywordsFile) throws FileNotFoundException {
        this(new FileInputStream(keywordsFile));
        if (!keywordsFile.exists() || keywordsFile.isDirectory() || !keywordsFile.canRead()) {
            LOG.error("Cannot read keywords from: " + keywordsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonGherkinKeywordProvider(InputStream inputStream) {
        try (InputStreamReader in2 = new InputStreamReader(inputStream, CharsetToolkit.UTF8_CHARSET);){
            Map fromJson = (Map)new Gson().fromJson((Reader)in2, new TypeToken<HashMap<String, HashMap<Object, Object>>>(){}.getType());
            for (Map.Entry entry : fromJson.entrySet()) {
                HashMap translation = (HashMap)entry.getValue();
                GherkinKeywordList keywordList = new GherkinKeywordList(translation);
                this.myLanguageKeywords.put((String)entry.getKey(), keywordList);
                for (String keyword : keywordList.getAllKeywords()) {
                    if (keywordList.getTokenType(keyword) != GherkinTokenTypes.STEP_KEYWORD) continue;
                    this.myAllStepKeywords.add(keyword);
                }
            }
        }
        catch (MalformedJsonException in2) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public Collection<String> getAllKeywords(String language) {
        return this.getKeywordList(language).getAllKeywords();
    }

    @Override
    public IElementType getTokenType(String language, String keyword) {
        return this.getKeywordList(language).getTokenType(keyword);
    }

    @Override
    public String getBaseKeyword(String language, String keyword) {
        return this.getKeywordList(language).getBaseKeyword(keyword);
    }

    @Override
    public boolean isSpaceAfterKeyword(String language, String keyword) {
        return this.getKeywordList(language).isSpaceAfterKeyword(keyword);
    }

    @Override
    public boolean isStepKeyword(String keyword) {
        return this.myAllStepKeywords.contains(keyword);
    }

    @Override
    @NotNull
    public GherkinKeywordTable getKeywordsTable(@Nullable String language) {
        GherkinKeywordTable gherkinKeywordTable = this.getKeywordList(language).getKeywordsTable();
        if (gherkinKeywordTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/i18n/JsonGherkinKeywordProvider", "getKeywordsTable"));
        }
        return gherkinKeywordTable;
    }

    @NotNull
    private GherkinKeywordList getKeywordList(@Nullable String language) {
        GherkinKeywordList keywordList = this.myLanguageKeywords.get(language);
        if (keywordList == null) {
            keywordList = this.myEmptyKeywordList;
        }
        GherkinKeywordList gherkinKeywordList = keywordList;
        if (gherkinKeywordList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/i18n/JsonGherkinKeywordProvider", "getKeywordList"));
        }
        return gherkinKeywordList;
    }
}

