/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.jest.JestConfig;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final String FRAMEWORK_NAME = "JestJavaScriptTestRunner";
    private static final String INTELLIJ_JEST_JASMINE_REPORTER = "jest-intellij/lib/jest-intellij-jasmine.js";
    private static final String CONFIG_SETUP_TEST_FRAMEWORK_SCRIPT_FILE = "_JEST_SETUP_TEST_FRAMEWORK_SCRIPT_FILE_OVERWRITTEN_BY_INTELLIJ";
    private static final String TEST_RUN_FROM_SINGLE_TEST_FILE = "_INTELLIJ_JEST_TEST_RUN_FROM_SINGLE_TEST_FILE";
    private static final String JEST_CONFIG_ROOT_DIR = "_INTELLIJ_JEST_CONFIG_ROOT_DIR";
    private static volatile File TEMP_INPUT_FILE;
    private final Project myProject;
    private final JestRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myJestPackage;
    private final JestRunSettings myRunSettings;

    public JestRunState(@NotNull JestRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage jestPackage) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/jest/JestRunState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/jest/JestRunState", "<init>"));
        }
        if (jestPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jestPackage", "com/intellij/javascript/jest/JestRunState", "<init>"));
        }
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myJestPackage = jestPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunState", "execute"));
        }
        return defaultExecutionResult;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/jest/JestRunState", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(){

            @NotNull
            protected Process startProcess(@NotNull List<String> commands) throws IOException {
                if (commands == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/javascript/jest/JestRunState$1", "startProcess"));
                }
                ProcessBuilder builder = new ProcessBuilder(commands);
                this.setupEnvironment(builder.environment());
                builder.directory(this.getWorkDirectory());
                builder.redirectErrorStream(this.isRedirectErrorStream());
                if (SystemInfo.isWindows) {
                    File input = TEMP_INPUT_FILE;
                    if (input == null || !input.isFile()) {
                        input = FileUtil.createTempFile((String)"intellij-jest-empty-input", null, (boolean)true);
                        TEMP_INPUT_FILE = input;
                    }
                    builder.redirectInput(ProcessBuilder.Redirect.from(input));
                }
                Process process = builder.start();
                if (process == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunState$1", "startProcess"));
                }
                return process;
            }
        };
        commandLine.setRedirectErrorStream(true);
        commandLine.setCharset(StandardCharsets.UTF_8);
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (!workingDir.isEmpty()) {
            commandLine.setWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptions(commandLine, Collections.emptyList(), debugPort, interpreter, Registry.is((String)"jest.debugger.use.inspect", (boolean)false));
        commandLine.addParameter(JestUtil.getJestMainJsFile(this.myJestPackage).getAbsolutePath());
        JestConfig config = JestConfig.create(this.myRunSettings.getConfigFileSystemDependentPath(), this.myRunSettings.getWorkingDirSystemDependentPath());
        this.configureEnvironment(commandLine, config);
        if (JestUtil.isReactScriptsPackage(this.myJestPackage)) {
            commandLine.getEnvironment().put("CI", "1");
        } else {
            commandLine.addParameters(new String[]{"--config"});
            commandLine.addParameter(config.stringifyConfig());
        }
        if (StringUtil.isNotEmpty((String)this.myRunSettings.getJestOptions())) {
            commandLine.addParameters(ParametersList.parse((String)this.myRunSettings.getJestOptions()));
        }
        if (debugPort != -1) {
            commandLine.addParameter("--runInBand");
        }
        commandLine.addParameter("--colors");
        commandLine.addParameter("--setupTestFrameworkScriptFile");
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(INTELLIJ_JEST_JASMINE_REPORTER));
        JestScopeKind scopeKind = this.myRunSettings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testPathPattern");
            commandLine.addParameter("^" + JestUtil.escapeJavaScriptRegex(this.myRunSettings.getTestFileSystemDependentPath(), "") + "$");
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testNamePattern");
            if (scopeKind == JestScopeKind.SUITE) {
                commandLine.addParameter("^" + this.formatTestNameEscapedRegex() + " ");
            } else {
                String topLevelSuiteRegex = this.myRunSettings.getTestNames().size() == 1 ? "(test )?" : "";
                commandLine.addParameter("^" + topLevelSuiteRegex + this.formatTestNameEscapedRegex() + "$");
            }
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunState", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private String formatTestNameEscapedRegex() {
        String string = JestUtil.escapeJavaScriptRegex(StringUtil.join(this.myRunSettings.getTestNames(), (String)" "), "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunState", "formatTestNameEscapedRegex"));
        }
        return string;
    }

    private void configureEnvironment(@NotNull GeneralCommandLine commandLine, @NotNull JestConfig config) {
        JestScopeKind scopeKind;
        String rootDir;
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/javascript/jest/JestRunState", "configureEnvironment"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/javascript/jest/JestRunState", "configureEnvironment"));
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        String configSetupTestFrameworkScriptFile = config.getSetupTestFrameworkScriptFile();
        if (configSetupTestFrameworkScriptFile != null) {
            commandLine.getEnvironment().put(CONFIG_SETUP_TEST_FRAMEWORK_SCRIPT_FILE, configSetupTestFrameworkScriptFile);
        }
        if ((rootDir = config.getRootDir()) != null) {
            commandLine.getEnvironment().put(JEST_CONFIG_ROOT_DIR, rootDir);
        }
        if ((scopeKind = this.myRunSettings.getScopeKind()) == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.getEnvironment().put(TEST_RUN_FROM_SINGLE_TEST_FILE, Boolean.TRUE.toString());
        }
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory) {
        JestConsoleProperties testConsoleProperties = new JestConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider(true));
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunState", "createSmtRunnerConsoleView"));
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/javascript/jest/JestRunState", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javascript/jest/JestRunState", "foldCommandLine"));
        }
        ArrayList commands = ContainerUtil.newArrayList((Object[])new String[]{"jest"});
        String configFileName = PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath());
        if (!configFileName.isEmpty()) {
            commands.add("--config");
            commands.add(configFileName);
        }
        JsbtUtil.foldCommandLine(consoleView, processHandler, ParametersListUtil.join((List)commands));
    }

    public static class JestOutputToGeneralTestEventsConverter
    extends OutputToGeneralTestEventsConverter {
        public JestOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean stdinEnabled) {
            if (testFrameworkName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/javascript/jest/JestRunState$JestOutputToGeneralTestEventsConverter", "<init>"));
            }
            super(testFrameworkName, stdinEnabled);
        }

        protected void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
            int ind = text.indexOf("##teamcity[");
            if (ind > 0) {
                super.processConsistentText(text.substring(0, ind), outputType, false);
                super.processConsistentText(text.substring(ind), outputType, false);
            } else {
                super.processConsistentText(text, outputType, false);
            }
        }
    }

    private static class JestConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        public JestConsoleProperties(@NotNull JestRunConfiguration configuration, @NotNull Executor executor, @NotNull SMTestLocator locator) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/jest/JestRunState$JestConsoleProperties", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/jest/JestRunState$JestConsoleProperties", "<init>"));
            }
            if (locator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/intellij/javascript/jest/JestRunState$JestConsoleProperties", "<init>"));
            }
            super((RunConfiguration)configuration, JestRunState.FRAMEWORK_NAME, executor);
            this.myLocator = locator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        public JestOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/javascript/jest/JestRunState$JestConsoleProperties", "createTestEventsConverter"));
            }
            if (consoleProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/javascript/jest/JestRunState$JestConsoleProperties", "createTestEventsConverter"));
            }
            return new JestOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }
    }
}

