/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForRequireModuleInfo {
    private final VirtualFile myModuleSourceRoot;
    @NotNull
    private final VirtualFile myModuleFile;
    @Nullable
    private final NodeModuleSearchUtil.ModuleMainFiles myMainFile;
    @NotNull
    private final ModuleType myType;

    public ForRequireModuleInfo(VirtualFile moduleSourceRoot, @NotNull VirtualFile moduleFile, @Nullable NodeModuleSearchUtil.ModuleMainFiles mainFile, @NotNull ModuleType type) {
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "com/intellij/javascript/nodejs/ForRequireModuleInfo", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/ForRequireModuleInfo", "<init>"));
        }
        this.myModuleSourceRoot = moduleSourceRoot;
        this.myModuleFile = moduleFile;
        this.myMainFile = mainFile;
        this.myType = type;
    }

    public VirtualFile getModuleSourceRoot() {
        return this.myModuleSourceRoot;
    }

    @NotNull
    public VirtualFile getModuleFile() {
        VirtualFile virtualFile = this.myModuleFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/ForRequireModuleInfo", "getModuleFile"));
        }
        return virtualFile;
    }

    public boolean isMainFile() {
        if (this.myMainFile == null) {
            return false;
        }
        return this.myModuleFile.equals(this.myMainFile.getJsNextMain()) || this.myModuleFile.equals(this.myMainFile.getMain());
    }

    @NotNull
    public ModuleType getType() {
        ModuleType moduleType = this.myType;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/ForRequireModuleInfo", "getType"));
        }
        return moduleType;
    }

    @Nullable
    public NodeModuleSearchUtil.ModuleMainFiles getMainFile() {
        return this.myMainFile;
    }
}

