/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeftRightJustifyingLayoutManager
implements LayoutManager {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component child = LeftRightJustifyingLayoutManager.getChildComponent(container);
        Dimension dim = child != null ? child.getPreferredSize() : null;
        return LeftRightJustifyingLayoutManager.calcLayoutSize(container, dim);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Component child = LeftRightJustifyingLayoutManager.getChildComponent(container);
        Dimension dim = child != null ? child.getMinimumSize() : null;
        return LeftRightJustifyingLayoutManager.calcLayoutSize(container, dim);
    }

    @Override
    public void layoutContainer(Container container) {
        Component child = LeftRightJustifyingLayoutManager.getChildComponent(container);
        if (child != null) {
            Dimension pref = child.getPreferredSize();
            Insets insets = container.getInsets();
            int availableWidth = container.getWidth() - insets.left - insets.right;
            if (pref.width <= availableWidth) {
                child.setBounds(insets.left, insets.top, pref.width, pref.height);
            } else {
                child.setBounds(availableWidth + insets.left - pref.width, insets.top, pref.width, pref.height);
            }
        }
    }

    @Nullable
    private static Component getChildComponent(Container container) {
        if (container.getComponentCount() > 0) {
            return container.getComponent(0);
        }
        return null;
    }

    @NotNull
    private static Dimension calcLayoutSize(@NotNull Container container, @Nullable Dimension childComponentDimension) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/javascript/nodejs/interpreter/LeftRightJustifyingLayoutManager", "calcLayoutSize"));
        }
        Insets insets = container.getInsets();
        Dimension dim = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        if (childComponentDimension != null) {
            dim.width += childComponentDimension.width;
            dim.height += childComponentDimension.height;
        }
        Dimension dimension = dim;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/LeftRightJustifyingLayoutManager", "calcLayoutSize"));
        }
        return dimension;
    }
}

