/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreterDialog
extends DialogWrapper {
    private final NodeJsLocalInterpreterEditor myEditor;

    protected NodeJsLocalInterpreterDialog(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterDialog", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterDialog", "<init>"));
        }
        super(project, true);
        this.myEditor = new NodeJsLocalInterpreterEditor(project);
        this.myEditor.resetEditor(interpreter);
        this.myEditor.setPreferredWidthToFitText();
        this.setTitle("Node.js Local Interpreter");
        this.init();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myEditor.getEditorComponent();
    }

    @Nullable
    public NodeJsLocalInterpreter edit() {
        if (this.showAndGet()) {
            return this.myEditor.applyEditor();
        }
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        NodeJsLocalInterpreter localInterpreter = this.myEditor.applyEditor();
        try {
            localInterpreter.getValidNpmCliJsFilePath(null);
        }
        catch (ExecutionException e) {
            return new ValidationInfo(e.getMessage());
        }
        return null;
    }

    public static void edit(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterDialog", "edit"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterDialog", "edit"));
        }
        NodeJsLocalInterpreterDialog dialog = new NodeJsLocalInterpreterDialog(project, interpreter);
        if (dialog.showAndGet()) {
            NodeJsLocalInterpreter result = dialog.myEditor.applyEditor();
            interpreter.setNpmPackageDir(result.getNpmPackageDir());
        }
    }
}

