/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class NodeJsLocalInterpreterEditor
implements NodeJsInterpreterEditor<NodeJsLocalInterpreter> {
    private final JBTextField myNodeField;
    private final NodePackageField myNpmPackageField;
    private final JPanel myPanel;
    private NodeJsLocalInterpreter myInterpreter;

    public NodeJsLocalInterpreterEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "<init>"));
        }
        this.myNodeField = new JBTextField();
        this.myNodeField.setEditable(false);
        this.myNpmPackageField = new NodePackageField(project, ContainerUtil.newArrayList((Object[])new String[]{"npm", "yarn"}), () -> this.myInterpreter);
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent("&Node interpreter:", (JComponent)this.myNodeField).addLabeledComponent("Np&m package:", (JComponent)((Object)this.myNpmPackageField)).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    public void setPreferredWidthToFitText() {
        SwingHelper.setPreferredWidthToFitText((JTextField)this.myNodeField);
        this.myNpmPackageField.setPreferredWidthToFitText();
    }

    @Override
    public void resetEditor(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "resetEditor"));
        }
        this.myInterpreter = interpreter;
        this.myNodeField.setText(interpreter.getPresentableName());
        this.myNpmPackageField.setSelected(new NodePackage(interpreter.getNpmPackageDir()));
    }

    @Override
    @NotNull
    public NodeJsLocalInterpreter applyEditor() {
        NodePackage pkg = this.myNpmPackageField.getSelected();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = new NodeJsLocalInterpreter(this.myInterpreter.getInterpreterSystemDependentPath(), pkg.getSystemDependentPath());
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "applyEditor"));
        }
        return nodeJsLocalInterpreter;
    }

    @Override
    @NotNull
    public JComponent getEditorComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor", "getEditorComponent"));
        }
        return jPanel;
    }
}

