/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.ide.IconProvider;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesDirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            return NodeModulesDirectoryIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
        }
        return null;
    }

    @Nullable
    private static Icon getDirectoryIcon(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getDirectoryIcon"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "getDirectoryIcon"));
        }
        boolean excluded = ProjectFileIndex.SERVICE.getInstance((Project)project).isExcluded(file);
        if (excluded && NodeModulesDirectoryIconProvider.hasLibraryFilesInside(project, file)) {
            return PlatformIcons.DIRECTORY_CLOSED_ICON;
        }
        return null;
    }

    private static boolean hasLibraryFilesInside(@NotNull Project project, @NotNull VirtualFile file) {
        NodeModulesDirectoryManager manager;
        VirtualFile dir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "hasLibraryFilesInside"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider", "hasLibraryFilesInside"));
        }
        VirtualFile nodeModulesDir = null;
        VirtualFile scopeDir = null;
        VirtualFile packageDir = null;
        VirtualFile dirInsidePackage = null;
        for (dir = file; dir != null; dir = dir.getParent()) {
            dirInsidePackage = packageDir;
            packageDir = scopeDir;
            scopeDir = nodeModulesDir;
            nodeModulesDir = dir;
            if (NodeModulesDirectoryManager.isNodeModulesDir(dir)) break;
        }
        if (dir == null) {
            return false;
        }
        if (scopeDir != null && !NodeModuleSearchUtil.isScopeName(scopeDir)) {
            dirInsidePackage = packageDir;
            packageDir = scopeDir;
            scopeDir = null;
        }
        if ((manager = NodeModulesDirectoryManager.getInstance(project)).isLibraryWithMappings(nodeModulesDir)) {
            if (scopeDir == null && packageDir == null) {
                return true;
            }
            VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
            if (packageJson == null) {
                return false;
            }
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            String scopeDirName = null;
            if (scopeDir != null) {
                scopeDirName = scopeDir.getName();
                if (packageDir == null && data.containsDependencyWithScope(scopeDirName)) {
                    return true;
                }
            }
            if (packageDir != null) {
                String packageName;
                String string = packageName = scopeDirName != null ? scopeDirName + "/" + packageDir.getName() : packageDir.getName();
                if (NodeModulesLibraryProvider.isDependencyIndexed(data, packageName) && (dirInsidePackage == null || NodeModulesLibraryProvider.isDependencyChildIncluded(dirInsidePackage))) {
                    return true;
                }
            }
        }
        return false;
    }
}

