/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesLibrariesSnapshot;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryUpdater;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeModulesDirectoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class NodeModulesDirectoryManager
implements PersistentStateComponent<Element> {
    public static final String TYPES_SCOPE_NAME = "@types";
    private static final Logger LOG = Logger.getInstance(NodeModulesDirectoryManager.class);
    private static final String HANDLED_PATH = "handled-path";
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, Boolean> myHandledNodeModulesDirs;
    private volatile ProjectModelExcludedDirectories myNodeModulesDirsExcludedByProjectModel;
    private final AtomicReference<NodeModulesLibrariesSnapshot> mySnapshotRef;
    private final Map<VirtualFile, PackageJsonData> myDataByPackageJsonMap;
    private final NodeModulesLibraryUpdater myScheduler;
    private final ProjectFileIndex myFileIndex;
    private final RecursionGuard myRecursionGuard;

    public NodeModulesDirectoryManager(@NotNull Project project, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "<init>"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "<init>"));
        }
        this.myHandledNodeModulesDirs = ContainerUtil.newConcurrentMap();
        this.myNodeModulesDirsExcludedByProjectModel = null;
        this.mySnapshotRef = new AtomicReference();
        this.myDataByPackageJsonMap = ContainerUtil.newConcurrentMap();
        this.myRecursionGuard = RecursionManager.createGuard((String)this.getClass().getName());
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myScheduler = new NodeModulesLibraryUpdater(project, 300L);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PackageJsonListener(), (Disposable)project);
    }

    @Nullable
    public <T> T computeFileIndexExtensionPreventingRecursion(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "computeFileIndexExtensionPreventingRecursion"));
        }
        Object result = this.myRecursionGuard.doPreventingRecursion((Object)this, false, computation);
        if (result == null) {
            LOG.error(new Throwable("Recursion prevented when computing FileIndex extension"));
        }
        return (T)result;
    }

    @NotNull
    public static NodeModulesDirectoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getInstance"));
        }
        NodeModulesDirectoryManager nodeModulesDirectoryManager = (NodeModulesDirectoryManager)ServiceManager.getService((Project)project, NodeModulesDirectoryManager.class);
        if (nodeModulesDirectoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getInstance"));
        }
        return nodeModulesDirectoryManager;
    }

    @Nullable
    public Element getState() {
        Element root = new Element("x");
        ArrayList paths = ContainerUtil.newArrayList();
        for (VirtualFile file : this.myHandledNodeModulesDirs.keySet()) {
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)HANDLED_PATH, (List)paths);
        return root;
    }

    public void loadState(Element state) {
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)HANDLED_PATH);
        paths = ContainerUtil.newArrayList((Iterable)paths);
        NodeModulesDirectoryManager.removeNestedNodeModulesPaths(paths);
        this.myHandledNodeModulesDirs.clear();
        for (String path : paths) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null || !file.isValid() || !NodeModulesDirectoryManager.isNodeModulesDir(file)) continue;
            this.myHandledNodeModulesDirs.put(file, true);
        }
    }

    private static void removeNestedNodeModulesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "removeNestedNodeModulesPaths"));
        }
        Collections.sort(paths);
        String prevPath = null;
        Iterator<String> i = paths.iterator();
        while (i.hasNext()) {
            String path = i.next();
            if (prevPath != null && path.startsWith(prevPath)) {
                LOG.warn("Removing descendant " + path);
                i.remove();
                continue;
            }
            prevPath = path;
        }
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getNodeModulesDirectories() {
        List<NodeModulesLibraryDirectory> list = this.getOrCreateSnapshot().getLibraryDirs();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getNodeModulesDirectories"));
        }
        return list;
    }

    @NotNull
    private ProjectModelExcludedDirectories getNodeModulesDirsExcludedByProjectModel() {
        ProjectModelExcludedDirectories ed = this.myNodeModulesDirsExcludedByProjectModel;
        long modificationCount = ProjectRootManager.getInstance((Project)this.myProject).getModificationCount();
        if (ed == null || ed.myModificationCount != modificationCount) {
            this.myNodeModulesDirsExcludedByProjectModel = ed = this.buildProjectModelExcludedDirectories();
        }
        ProjectModelExcludedDirectories projectModelExcludedDirectories = ed;
        if (projectModelExcludedDirectories == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getNodeModulesDirsExcludedByProjectModel"));
        }
        return projectModelExcludedDirectories;
    }

    @NotNull
    private ProjectModelExcludedDirectories buildProjectModelExcludedDirectories() {
        ProjectModelExcludedDirectories projectModelExcludedDirectories = (ProjectModelExcludedDirectories)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return new ProjectModelExcludedDirectories(0L, Collections.emptySet());
            }
            HashSet dirs = ContainerUtil.newHashSet();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (VirtualFile dir : ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
                    if (!NodeModulesDirectoryManager.isNodeModulesDir(dir)) continue;
                    dirs.add(dir);
                }
            }
            long modificationCount = ProjectRootManager.getInstance((Project)this.myProject).getModificationCount();
            return new ProjectModelExcludedDirectories(modificationCount, dirs);
        });
        if (projectModelExcludedDirectories == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "buildProjectModelExcludedDirectories"));
        }
        return projectModelExcludedDirectories;
    }

    public boolean isLibraryWithMappings(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "isLibraryWithMappings"));
        }
        String libraryName = this.getOrCreateSnapshot().findLibraryName(nodeModulesDir);
        if (libraryName != null) {
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
            return !mappings.getMappingsByLibraryName(libraryName).isEmpty();
        }
        return false;
    }

    public boolean isLibraryWithMappings(@NotNull NodeModulesLibraryDirectory libraryDirectory) {
        if (libraryDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDirectory", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "isLibraryWithMappings"));
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
        return !mappings.getMappingsByLibraryName(libraryDirectory.getLibraryName()).isEmpty();
    }

    public static boolean isNodeModulesDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "isNodeModulesDir"));
        }
        return dir.isDirectory() && StringUtil.equals((CharSequence)"node_modules", (CharSequence)dir.getNameSequence());
    }

    public static boolean isForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "isForApplicationSourceCode"));
        }
        VirtualFile parent = nodeModulesDir.getParent();
        if (parent != null) {
            VirtualFile packageJson = parent.findChild("package.json");
            return packageJson == null || packageJson.isValid() && packageJson.isDirectory();
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> getNodeModulesDirsNotExcludedByProjectModel() {
        Set excludedByProjectModel = this.getNodeModulesDirsExcludedByProjectModel().myNodeModulesDirs;
        List result = ContainerUtil.filter(this.getNodeModulesDirectories(), directory -> {
            VirtualFile nodeModulesDir = directory.getNodeModulesDir();
            return nodeModulesDir.isValid() && !excludedByProjectModel.contains(nodeModulesDir) && !directory.isForApplicationSourceCode();
        });
        List list = ContainerUtil.mapNotNull((Collection)result, NodeModulesLibraryDirectory::getNodeModulesDir);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getNodeModulesDirsNotExcludedByProjectModel"));
        }
        return list;
    }

    public void projectOpened() {
        NodeModulesDirsCollector collector = new NodeModulesDirsCollector();
        this.removeOldLibraries(collector, () -> {
            this.detectNodeModules(collector);
            Collection<DirInfo> topLevelDirInfos = collector.getTopLevelNodeModulesDirInfos();
            this.tryAddLibraries(topLevelDirInfos);
        });
    }

    private void detectNodeModules(@NotNull NodeModulesDirsCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "detectNodeModules"));
        }
        ReadAction.run(() -> {
            if (collector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "lambda$detectNodeModules$3"));
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild("node_modules");
                    if (nodeModulesDir == null || !nodeModulesDir.isValid() || !nodeModulesDir.isDirectory()) continue;
                    collector.add(nodeModulesDir);
                }
            }
            try {
                Collection foundDirs = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"node_modules", (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
                for (VirtualFile dir : foundDirs) {
                    collector.add(dir);
                }
            }
            catch (ProcessCanceledException e) {
                LOG.info("Failed to locate all node_modules/ in project");
            }
        });
    }

    @Nullable
    private VirtualFile findTopLevelNodeModulesDirInsideContentRoots(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile result = null;
        while (nodeModulesDir != null && this.myFileIndex.getContentRootForFile(nodeModulesDir, false) != null) {
            result = nodeModulesDir;
            nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(nodeModulesDir);
        }
        return result;
    }

    private void removeOldLibraries(@NotNull NodeModulesDirsCollector collector, @NotNull Runnable onDone) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "removeOldLibraries"));
        }
        if (onDone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDone", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "removeOldLibraries"));
        }
        List<ScriptingLibraryModel> libraries = this.listOldLibraries(collector);
        if (libraries.isEmpty()) {
            onDone.run();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (onDone == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDone", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "lambda$removeOldLibraries$5"));
                }
                WriteAction.run(() -> {
                    if (onDone == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDone", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "lambda$null$4"));
                    }
                    JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
                    JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
                    for (ScriptingLibraryModel library : libraries) {
                        List files = libraryMappings.getMappingsByLibraryName(library.getName());
                        for (VirtualFile file : files) {
                            libraryMappings.disassociate(file, library.getName());
                        }
                        libraryManager.removeLibrary(library);
                        LOG.info("Removed library '" + library.getName() + "'");
                    }
                    libraryManager.commitChanges();
                    ApplicationManager.getApplication().executeOnPooledThread(onDone);
                });
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    @NotNull
    private List<ScriptingLibraryModel> listOldLibraries(@NotNull NodeModulesDirsCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "listOldLibraries"));
        }
        List list = (List)ReadAction.compute(() -> {
            ScriptingLibraryModel[] libraries;
            if (collector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "lambda$listOldLibraries$7"));
            }
            ArrayList result = ContainerUtil.newArrayList();
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            for (ScriptingLibraryModel library : libraries = libraryManager.getLibraries(ScriptingLibraryModel.LibraryLevel.PROJECT)) {
                boolean matches;
                ScriptingFrameworkDescriptor descriptor = library.getFrameworkDescriptor();
                boolean bl = matches = descriptor != null && "node_modules".equals(descriptor.getFrameworkName()) && library.getName().endsWith(" node_modules");
                if (!matches && library.getName().startsWith("Node.js Dependencies for ")) {
                    matches = library.getSourceFiles().stream().allMatch(file -> !file.isValid() || NodeModulesDirectoryManager.isNodeModulesDir(file));
                }
                if (!matches) continue;
                result.add(library);
                List mappings = JSLibraryMappings.getInstance(this.myProject).getMappingsByLibraryName(library.getName());
                for (VirtualFile file2 : library.getSourceFiles()) {
                    collector.add(file2, mappings, false);
                }
            }
            return result;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "listOldLibraries"));
        }
        return list;
    }

    private void tryAddLibraries(@NotNull Collection<DirInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "tryAddLibraries"));
        }
        List infosToProcess = ContainerUtil.newSmartList();
        for (DirInfo info : infos) {
            boolean added;
            boolean bl = added = this.myHandledNodeModulesDirs.putIfAbsent(info.myNodeModulesDir, true) == null;
            if (!added && !info.myForceAddMappings || NodeModulesDirectoryManager.isForApplicationSourceCode(info.myNodeModulesDir)) continue;
            infosToProcess.add(info);
        }
        if (infosToProcess.isEmpty()) {
            return;
        }
        this.mySnapshotRef.set(null);
        NodeModulesLibrariesSnapshot snapshot = this.getOrCreateSnapshot();
        Runnable task = () -> WriteAction.run(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            libraryManager.commitChanges();
            for (DirInfo info : infosToProcess) {
                VirtualFile nodeModulesDir = info.myNodeModulesDir;
                String libraryName = snapshot.findLibraryName(nodeModulesDir);
                if (libraryName == null) {
                    LOG.warn("No library name calculated for " + nodeModulesDir.getPath());
                    continue;
                }
                List mappings = info.myMappings;
                if (!mappings.isEmpty()) {
                    if (libraryManager.getLibraryByName(libraryName) == null) {
                        LOG.warn("Cannot find library by name " + libraryName + ", " + nodeModulesDir.getPath());
                        continue;
                    }
                    for (VirtualFile mapping : mappings) {
                        libraryManager.getLibraryMappings().associate(mapping, libraryName, true);
                    }
                }
                LOG.info("Associate " + libraryName + " with " + mappings);
            }
            libraryManager.commitChanges();
        });
        if (ourUnitTestMode) {
            task.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)task);
        }
    }

    @NotNull
    private NodeModulesLibrariesSnapshot getOrCreateSnapshot() {
        NodeModulesLibrariesSnapshot snapshot = this.mySnapshotRef.get();
        while (snapshot == null) {
            snapshot = new NodeModulesLibrariesSnapshot(this.myProject, this.myHandledNodeModulesDirs.keySet());
            this.mySnapshotRef.compareAndSet(null, snapshot);
            snapshot = this.mySnapshotRef.get();
        }
        NodeModulesLibrariesSnapshot nodeModulesLibrariesSnapshot = snapshot;
        if (nodeModulesLibrariesSnapshot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "getOrCreateSnapshot"));
        }
        return nodeModulesLibrariesSnapshot;
    }

    public void setProvidedPackageJsonRoots(@NotNull VirtualFile packageJson, @NotNull PackageJsonData data) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "setProvidedPackageJsonRoots"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "setProvidedPackageJsonRoots"));
        }
        this.myDataByPackageJsonMap.put(packageJson, data);
    }

    private void handleAddingPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "handleAddingPackageJson"));
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson)) {
            LOG.info("Adding " + packageJson.getPath());
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                this.handleAddingNodeModulesDir(nodeModulesDir);
            } else {
                this.myScheduler.scheduleUpdate();
            }
        }
    }

    private boolean isInLibrary(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "isInLibrary"));
        }
        return this.myFileIndex.isInLibraryClasses(nodeModulesDir) || this.myFileIndex.isInLibrarySource(nodeModulesDir);
    }

    private void handlePackageJsonRemoved(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "handlePackageJsonRemoved"));
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && this.myDataByPackageJsonMap.remove(packageJson) != null) {
            LOG.info("Removing " + packageJson.getPath());
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            if (nodeModulesDir != null && nodeModulesDir.isValid()) {
                this.myHandledNodeModulesDirs.remove(nodeModulesDir);
            }
            this.myScheduler.scheduleUpdate();
        }
    }

    private void handlePackageJsonContentChanged(@NotNull VirtualFile packageJson) {
        PackageJsonData oldData;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "handlePackageJsonContentChanged"));
        }
        if (PackageJsonUtil.isPackageJsonFile(packageJson) && (oldData = this.myDataByPackageJsonMap.get(packageJson)) != null) {
            LOG.info("Changing " + packageJson.getPath());
            PackageJsonData newData = PackageJsonUtil.getOrCreateData(packageJson);
            if (!newData.getAllDependencies().equals(oldData.getAllDependencies())) {
                this.myDataByPackageJsonMap.put(packageJson, newData);
                this.myScheduler.scheduleUpdate();
            }
        }
    }

    private void handleAddingNodeModulesDir(@NotNull VirtualFile file) {
        VirtualFile topLevelNodeModulesDir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "handleAddingNodeModulesDir"));
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file) && (topLevelNodeModulesDir = this.findTopLevelNodeModulesDirInsideContentRoots(file)) != null && this.myFileIndex.isInContent(topLevelNodeModulesDir) && !this.isInLibrary(topLevelNodeModulesDir)) {
            this.tryAddLibraries(Collections.singletonList(new DirInfo(topLevelNodeModulesDir, true)));
        }
    }

    private void handleRemovingNodeModulesDir(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager", "handleRemovingNodeModulesDir"));
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(file) && this.myHandledNodeModulesDirs.remove(file) != null) {
            this.mySnapshotRef.set(null);
            this.myScheduler.scheduleUpdate();
        }
    }

    private static class DirInfo {
        private final VirtualFile myNodeModulesDir;
        private final List<VirtualFile> myMappings;
        private final boolean myForceAddMappings;

        public DirInfo(@NotNull VirtualFile nodeModulesDir, @NotNull List<VirtualFile> mappings, boolean forceAddMappings) {
            if (nodeModulesDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$DirInfo", "<init>"));
            }
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$DirInfo", "<init>"));
            }
            this.myNodeModulesDir = nodeModulesDir;
            this.myMappings = mappings;
            this.myForceAddMappings = forceAddMappings;
        }

        public DirInfo(@NotNull VirtualFile nodeModulesDir, boolean forceAddMappings) {
            if (nodeModulesDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$DirInfo", "<init>"));
            }
            this.myNodeModulesDir = nodeModulesDir;
            this.myMappings = ContainerUtil.createMaybeSingletonList((Object)nodeModulesDir.getParent());
            this.myForceAddMappings = forceAddMappings;
        }
    }

    private class NodeModulesDirsCollector {
        private final Map<VirtualFile, Pair<DirInfo, Boolean>> myInfos = ContainerUtil.newHashMap();

        private NodeModulesDirsCollector() {
        }

        public void add(@NotNull VirtualFile nodeModulesDir, @NotNull List<VirtualFile> mappings, boolean noLibraryIfExcluded) {
            if (nodeModulesDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$NodeModulesDirsCollector", "add"));
            }
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$NodeModulesDirsCollector", "add"));
            }
            this.add(new DirInfo(nodeModulesDir, mappings, !noLibraryIfExcluded), noLibraryIfExcluded);
        }

        public void add(@NotNull VirtualFile nodeModulesDir) {
            if (nodeModulesDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$NodeModulesDirsCollector", "add"));
            }
            this.add(new DirInfo(nodeModulesDir, false), true);
        }

        private void add(@NotNull DirInfo nodeModulesInfo, boolean noLibraryIfExcluded) {
            if (nodeModulesInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesInfo", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$NodeModulesDirsCollector", "add"));
            }
            VirtualFile nodeModulesDir = nodeModulesInfo.myNodeModulesDir;
            if (NodeModulesDirectoryManager.isNodeModulesDir(nodeModulesDir) && !this.myInfos.containsKey(nodeModulesDir)) {
                this.myInfos.put(nodeModulesDir, (Pair<DirInfo, Boolean>)Pair.create((Object)nodeModulesInfo, (Object)noLibraryIfExcluded));
            }
        }

        public Collection<DirInfo> getTopLevelNodeModulesDirInfos() {
            HashSet topLevelNodeModulesDirs = ContainerUtil.newHashSet();
            HashSet libraryDirsToWarn = ContainerUtil.newHashSet();
            for (Pair<DirInfo, Boolean> pair : this.myInfos.values()) {
                VirtualFile nodeModulesDir = ((DirInfo)pair.first).myNodeModulesDir;
                boolean noLibraryIfExcluded = (Boolean)pair.second;
                VirtualFile topLevelNodeModulesDir = NodeModulesDirectoryManager.this.findTopLevelNodeModulesDirInsideContentRoots(nodeModulesDir);
                if (topLevelNodeModulesDir == null) continue;
                if (!topLevelNodeModulesDir.equals(nodeModulesDir)) {
                    noLibraryIfExcluded = true;
                }
                if (noLibraryIfExcluded && !NodeModulesDirectoryManager.this.myFileIndex.isInContent(topLevelNodeModulesDir)) continue;
                topLevelNodeModulesDirs.add(topLevelNodeModulesDir);
                if (!NodeModulesDirectoryManager.this.isInLibrary(topLevelNodeModulesDir)) continue;
                libraryDirsToWarn.add(topLevelNodeModulesDir);
            }
            for (VirtualFile libraryDir : libraryDirsToWarn) {
                LOG.info("A library contains " + libraryDir);
            }
            return ContainerUtil.map2List((Collection)topLevelNodeModulesDirs, dir -> {
                Pair<DirInfo, Boolean> pair = this.myInfos.get(dir);
                return pair != null ? (DirInfo)pair.first : new DirInfo((VirtualFile)dir, false);
            });
        }
    }

    private static class ProjectModelExcludedDirectories {
        private final long myModificationCount;
        private final Set<VirtualFile> myNodeModulesDirs;

        /*
         * WARNING - void declaration
         */
        private ProjectModelExcludedDirectories(long modificationCount, @NotNull Set<VirtualFile> set) {
            void nodeModulesDirs;
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDirs", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$ProjectModelExcludedDirectories", "<init>"));
            }
            this.myModificationCount = modificationCount;
            this.myNodeModulesDirs = nodeModulesDirs;
        }
    }

    private class PackageJsonListener
    extends VirtualFileAdapter {
        private PackageJsonListener() {
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "beforePropertyChange"));
            }
            if ("name".equals(event.getPropertyName())) {
                NodeModulesDirectoryManager.this.handlePackageJsonRemoved(event.getFile());
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName())) {
                NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "contentsChanged"));
            }
            NodeModulesDirectoryManager.this.handlePackageJsonContentChanged(event.getFile());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile nodeModulesDir;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "fileCreated"));
            }
            VirtualFile file = event.getFile();
            NodeModulesDirectoryManager.this.handleAddingPackageJson(file);
            if (file.isDirectory() && StringUtil.equals((CharSequence)NodeModulesDirectoryManager.TYPES_SCOPE_NAME, (CharSequence)file.getNameSequence())) {
                NodeModulesDirectoryManager.this.myScheduler.scheduleUpdate();
            }
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(file);
            if (ourUnitTestMode && (nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file)) != null && NodeModulesDirectoryManager.this.getOrCreateSnapshot().findLibraryName(nodeModulesDir) != null) {
                NodeModulesDirectoryManager.this.myScheduler.scheduleUpdate();
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "fileDeleted"));
            }
            NodeModulesDirectoryManager.this.handlePackageJsonRemoved(event.getFile());
            NodeModulesDirectoryManager.this.handleRemovingNodeModulesDir(event.getFile());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "beforeFileMovement"));
            }
            NodeModulesDirectoryManager.this.handlePackageJsonRemoved(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "fileMoved"));
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/library/NodeModulesDirectoryManager$PackageJsonListener", "fileCopied"));
            }
            NodeModulesDirectoryManager.this.handleAddingPackageJson(event.getFile());
            NodeModulesDirectoryManager.this.handleAddingNodeModulesDir(event.getFile());
        }
    }
}

