/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class NodePackageEditor
implements ComboBoxEditor {
    public static final TextComponentAccessor<ComboBox<Object>> TEXT_COMPONENT_ACCESSOR = new NodePackageComboBoxTextComponentAccessor();
    private final SortedComboBoxModel<Object> myComboBoxModel;
    private final JPanel myMainPanel;
    private final JTextField myTextField;
    private final SimpleColoredComponent myVersionComp;
    private final Color myNormalForegroundColor;

    public NodePackageEditor(@NotNull SortedComboBoxModel<Object> comboBoxModel) {
        if (comboBoxModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBoxModel", "com/intellij/javascript/nodejs/util/NodePackageEditor", "<init>"));
        }
        this.myMainPanel = new JPanel(new GridBagLayout()){
            {
                this.setBorder(IdeBorderFactory.createEmptyBorder());
            }

            @Override
            public synchronized void addFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.addFocusListener(l);
            }

            @Override
            public synchronized void removeFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.removeFocusListener(l);
            }

            @Override
            public void setFocusable(boolean focusable) {
                super.setFocusable(false);
            }

            @Override
            public void setBorder(Border border) {
                super.setBorder(IdeBorderFactory.createEmptyBorder());
            }
        };
        this.myTextField = new JTextField();
        this.myVersionComp = new SimpleColoredComponent();
        this.myNormalForegroundColor = this.myTextField.getForeground();
        this.myComboBoxModel = comboBoxModel;
        this.myMainPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.myMainPanel.setBackground(this.myTextField.getBackground());
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)this.myTextField.getFont()));
        this.myVersionComp.setOpaque(false);
        this.myVersionComp.setForeground(this.myTextField.getForeground());
        this.myVersionComp.setIpad((Insets)JBUI.emptyInsets());
        this.myTextField.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)8));
        this.myVersionComp.setMyBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)1));
        this.myMainPanel.add((Component)this.myTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NodePackageEditor.this.textUpdated();
            }
        });
        this.myMainPanel.setFocusable(false);
        this.myVersionComp.setFocusable(false);
    }

    private void textUpdated() {
        NodePackage item = this.getItem();
        boolean valid = item.isValid();
        this.myTextField.setForeground(valid ? this.myNormalForegroundColor : JBColor.red);
        this.myVersionComp.clear();
        SemVer version = item.getVersion();
        if (version != null) {
            this.myVersionComp.append(version.getRawVersion(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    public JTextField getTextField() {
        JTextField jTextField = this.myTextField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageEditor", "getTextField"));
        }
        return jTextField;
    }

    @Override
    @NotNull
    public Component getEditorComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageEditor", "getEditorComponent"));
        }
        return jPanel;
    }

    @Override
    public void setItem(Object anObject) {
        String text;
        NodePackage pkg = (NodePackage)ObjectUtils.tryCast((Object)anObject, NodePackage.class);
        String string = text = pkg != null ? pkg.getPresentablePath() : "";
        if (!this.myTextField.getText().equals(text)) {
            this.myTextField.setText(text);
        }
    }

    @Override
    @NotNull
    public NodePackage getItem() {
        String text = FileUtil.expandUserHome((String)this.myTextField.getText().trim());
        NodePackage pkg = new NodePackage(text);
        int ind = this.myComboBoxModel.indexOf((Object)pkg);
        NodePackage nodePackage = ind >= 0 ? (NodePackage)this.myComboBoxModel.get(ind) : pkg;
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageEditor", "getItem"));
        }
        return nodePackage;
    }

    @Override
    public void selectAll() {
        this.myTextField.selectAll();
        this.myTextField.requestFocus();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.myTextField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.myTextField.removeActionListener(l);
    }

    private static class NodePackageComboBoxTextComponentAccessor
    implements TextComponentAccessor<ComboBox<Object>> {
        private NodePackageComboBoxTextComponentAccessor() {
        }

        public String getText(ComboBox<Object> component) {
            Object obj = component.getEditor().getItem();
            if (obj instanceof NodePackage) {
                return ((NodePackage)obj).getSystemDependentPath();
            }
            return "";
        }

        public void setText(ComboBox<Object> component, @NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/util/NodePackageEditor$NodePackageComboBoxTextComponentAccessor", "setText"));
            }
            component.getEditor().setItem(new NodePackage(text));
        }
    }
}

