/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProtractorOutputToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    private boolean myPostponedChunksEnabled;
    private final List<TextChunk> myPostponedChunks;

    public ProtractorOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean stdinEnabled) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter", "<init>"));
        }
        super(testFrameworkName, stdinEnabled);
        this.myPostponedChunksEnabled = true;
        this.myPostponedChunks = new ArrayList<TextChunk>();
    }

    private static boolean isStdout(@NotNull Key outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter", "isStdout"));
        }
        return outputType != ProcessOutputTypes.STDERR && outputType != ProcessOutputTypes.SYSTEM;
    }

    protected void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        if (ProtractorOutputToGeneralTestEventsConverter.isStdout(outputType)) {
            this.processStdoutConsistentText(text, outputType, tcLikeFakeOutput);
        } else {
            super.processConsistentText(text, outputType, tcLikeFakeOutput);
        }
    }

    private void printAndDisablePostponedChunks() {
        if (this.myPostponedChunksEnabled) {
            for (TextChunk chunk : this.myPostponedChunks) {
                if (chunk == null) continue;
                super.processConsistentText(chunk.myText, chunk.myOutputType, chunk.myTcLikeFakeOutput);
            }
            this.myPostponedChunks.clear();
            this.myPostponedChunksEnabled = false;
        }
    }

    private void discardAndDisablePostponedChunks() {
        this.myPostponedChunks.clear();
        this.myPostponedChunksEnabled = false;
    }

    private void resetPostponedChunks() {
        this.myPostponedChunks.clear();
        this.myPostponedChunksEnabled = true;
    }

    private void processStdoutConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        int logPrefixLength = -1;
        if (this.myPostponedChunksEnabled) {
            if (this.myPostponedChunks.size() == 0) {
                logPrefixLength = ProtractorOutputToGeneralTestEventsConverter.getProtractorLogPrefixLength(text);
                if (logPrefixLength == text.length()) {
                    this.myPostponedChunks.add(new TextChunk(text, outputType, tcLikeFakeOutput));
                } else if (logPrefixLength == 0 && ProtractorOutputToGeneralTestEventsConverter.isTestStatusCharacter(text)) {
                    this.myPostponedChunks.add(null);
                    this.myPostponedChunks.add(new TextChunk(text, outputType, tcLikeFakeOutput));
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else if (this.myPostponedChunks.size() == 1) {
                if (ProtractorOutputToGeneralTestEventsConverter.isTestStatusCharacter(text)) {
                    this.myPostponedChunks.add(new TextChunk(text, outputType, tcLikeFakeOutput));
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else if (this.myPostponedChunks.size() == 2) {
                if (text.startsWith("##teamcity[")) {
                    this.discardAndDisablePostponedChunks();
                } else {
                    this.printAndDisablePostponedChunks();
                }
            } else {
                this.printAndDisablePostponedChunks();
            }
        }
        if (!this.myPostponedChunksEnabled) {
            int ind = text.indexOf("##teamcity[");
            if (ind > 0) {
                if (ind != logPrefixLength) {
                    super.processConsistentText(text.substring(0, ind), outputType, false);
                }
                super.processConsistentText(text.substring(ind), outputType, false);
            } else {
                super.processConsistentText(text, outputType, false);
            }
        }
        if (StringUtil.getLineSeparatorAt((CharSequence)text, (int)(text.length() - 1)) != null) {
            this.printAndDisablePostponedChunks();
            this.resetPostponedChunks();
        }
    }

    private static boolean isTestStatusCharacter(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter", "isTestStatusCharacter"));
        }
        return text.length() == 1 && ".F".contains(text);
    }

    private static int getProtractorLogPrefixLength(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter", "getProtractorLogPrefixLength"));
        }
        int len = line.length();
        if (len == 0) {
            return 0;
        }
        if (line.charAt(0) != '[') {
            return 0;
        }
        int endInd = StringUtil.indexOf((CharSequence)line, (CharSequence)"] ");
        while (endInd > 0) {
            if (ProtractorOutputToGeneralTestEventsConverter.endsWithDefaultTaskId(line, endInd)) {
                return endInd + 2;
            }
            endInd = StringUtil.indexOf((CharSequence)line, (CharSequence)"] ", (int)(endInd + 1));
        }
        return 0;
    }

    private static boolean endsWithDefaultTaskId(@NotNull String line, int endInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorOutputToGeneralTestEventsConverter", "endsWithDefaultTaskId"));
        }
        int startInd = line.lastIndexOf(" #", endInd);
        if (startInd == -1) {
            return false;
        }
        for (int i = startInd + 2; i < endInd; ++i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    private static class TextChunk {
        private final String myText;
        private final Key myOutputType;
        private final boolean myTcLikeFakeOutput;

        public TextChunk(String text, Key outputType, boolean tcLikeFakeOutput) {
            this.myText = text;
            this.myOutputType = outputType;
            this.myTcLikeFakeOutput = tcLikeFakeOutput;
        }
    }
}

