/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class ProtractorRunConfigurationEditor
extends SettingsEditor<ProtractorRunConfiguration> {
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathTextFieldWithBrowseButton;
    private final NodeJsInterpreterField myInterpreterField;
    private final NodePackageField myProtractorPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public ProtractorRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.myConfigPathTextFieldWithBrowseButton = ProtractorRunConfigurationEditor.createConfigurationFileTextField(project);
        this.myInterpreterField = new NodeJsInterpreterField(project, false);
        this.myProtractorPackageField = new NodePackageField(project, "protractor", () -> this.myInterpreterField.getInterpreter());
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Configuration file:", (JComponent)this.myConfigPathTextFieldWithBrowseButton).addComponent((JComponent)new JSeparator(), JBUI.scale((int)8)).addLabeledComponent("Node &interpreter:", (JComponent)((Object)this.myInterpreterField), JBUI.scale((int)8)).addLabeledComponent("&Protractor package:", (JComponent)((Object)this.myProtractorPackageField)).addLabeledComponent("&Environment variables:", (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "lambda$createConfigurationFileTextField$2"));
            }
            List<VirtualFile> newFiles = ProtractorUtil.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file -> FileUtil.toSystemDependentName((String)file.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)"Select Protractor Configuration File", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "createConfigurationFileTextField"));
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    protected void resetEditorFrom(@NotNull ProtractorRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "resetEditorFrom"));
        }
        ProtractorRunSettings runSettings = runConfiguration.getRunSettings();
        this.myConfigPathTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getConfigFileSystemDependentPath());
        this.myInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        NodeJsInterpreter interpreter = runSettings.getInterpreterRef().resolve(this.myProject);
        NodePackage pkg = ProtractorUtil.getProtractorPackage(this.myProject, null, interpreter, true);
        this.myProtractorPackageField.setSelected(pkg);
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myInterpreterField.setPreferredWidthToFitText();
            this.myProtractorPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    protected void applyEditorTo(@NotNull ProtractorRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "applyEditorTo"));
        }
        ProtractorRunSettings.Builder builder = ProtractorRunSettings.builder();
        builder.setConfigFilePath(this.myConfigPathTextFieldWithBrowseButton.getText());
        ProtractorUtil.setProtractorPackage(this.myProject, this.myProtractorPackageField.getSelected());
        builder.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

