/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.Location;
import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.javascript.protractor.ProtractorConfigurationType;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfigurationProducer
extends CompatibleRunConfigurationProducer<ProtractorRunConfiguration> {
    protected ProtractorRunConfigurationProducer() {
        super((ConfigurationType)ProtractorConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        JSFile jsFile = ProtractorRunConfigurationProducer.getConfigJsFile(context.getLocation());
        if (jsFile == null) {
            return false;
        }
        VirtualFile configVirtualFile = jsFile.getVirtualFile();
        if (configVirtualFile == null) {
            return false;
        }
        sourceElement.set((Object)jsFile);
        ProtractorRunConfigurationProducer.setupProtractorConfiguration(configuration, configVirtualFile);
        return true;
    }

    private static void setupProtractorConfiguration(@NotNull ProtractorRunConfiguration configuration, @NotNull VirtualFile config) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "setupProtractorConfiguration"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "setupProtractorConfiguration"));
        }
        configuration.setConfigFile(config);
        String name = configuration.suggestedName();
        configuration.setName(name);
    }

    public boolean isConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        VirtualFile contextConfigVirtualFile = ProtractorRunConfigurationProducer.getFileFromContext(context);
        if (contextConfigVirtualFile == null) {
            return false;
        }
        String contextConfigFilePath = FileUtil.toSystemDependentName((String)contextConfigVirtualFile.getPath());
        String candidateConfigFilePath = configuration.getRunSettings().getConfigFileSystemDependentPath();
        return contextConfigFilePath.equals(candidateConfigFilePath);
    }

    @Nullable
    private static VirtualFile getFileFromContext(@Nullable ConfigurationContext context) {
        if (context == null) {
            return null;
        }
        PsiFile file = ProtractorRunConfigurationProducer.getPsiFile(context.getLocation());
        return file != null ? file.getVirtualFile() : null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Location location) {
        return location != null ? location.getPsiElement().getContainingFile() : null;
    }

    @Nullable
    private static JSFile getConfigJsFile(@Nullable Location location) {
        PsiFile file = ProtractorRunConfigurationProducer.getPsiFile(location);
        if (file instanceof JSFile && ProtractorUtil.isProtractorConfigFile(file.getName())) {
            return (JSFile)file;
        }
        return null;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }
}

