/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public class ProtractorRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myConfigFilePath;
    private final EnvironmentVariablesData myEnvData;

    public ProtractorRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/protractor/ProtractorRunSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myConfigFilePath = FileUtil.toSystemDependentName((String)builder.myConfigFilePath);
        this.myEnvData = builder.myEnvData;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getConfigFileSystemDependentPath() {
        String string = this.myConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings", "getConfigFileSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder().setInterpreterRef(this.myInterpreterRef).setConfigFilePath(this.myConfigFilePath).setEnvData(this.myEnvData);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings", "toBuilder"));
        }
        return builder;
    }

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        private String myConfigFilePath = "";
        private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setConfigFilePath(@NotNull String configFilePath) {
            if (configFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setConfigFilePath"));
            }
            this.myConfigFilePath = configFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setConfigFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public ProtractorRunSettings build() {
            ProtractorRunSettings protractorRunSettings = new ProtractorRunSettings(this);
            if (protractorRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorRunSettings$Builder", "build"));
            }
            return protractorRunSettings;
        }
    }
}

