/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorUtil {
    public static final String PACKAGE_NAME = "protractor";
    private static String[] SUFFIXES_WITHOUT_FIRST_CHAR = new String[]{"onf.js", "onfig.js"};
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String KEY__PROTRACTOR_PACKAGE_DIR = "nodejs.protractor.protractor_package";

    private ProtractorUtil() {
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "listPossibleConfigFilesInProject"));
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result = ContainerUtil.newArrayList();
        Collection files = FileTypeIndex.getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)scope);
        for (VirtualFile file : files) {
            if (file == null || !file.isValid() || file.isDirectory() || !ProtractorUtil.mightBeProtractorConfigFile(file.getNameSequence()) || JSLibraryUtil.isProbableLibraryFile(file)) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "listPossibleConfigFilesInProject"));
        }
        return arrayList;
    }

    @NotNull
    public static List<VirtualFile> listExactConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "listExactConfigFilesInProject"));
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList result = ContainerUtil.newArrayList();
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"protractor.conf.js", (GlobalSearchScope)scope);
        for (VirtualFile file : files) {
            if (file == null || !file.isValid() || file.isDirectory() || JSLibraryUtil.isProbableLibraryFile(file)) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "listExactConfigFilesInProject"));
        }
        return arrayList;
    }

    private static boolean mightBeProtractorConfigFile(@NotNull CharSequence fileName) {
        int delimInd;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/protractor/ProtractorUtil", "mightBeProtractorConfigFile"));
        }
        int suffixStartInd = ProtractorUtil.findSuffixStartInd(fileName);
        if (suffixStartInd == -1) {
            return false;
        }
        if (Character.isLowerCase(fileName.charAt(suffixStartInd)) && (delimInd = suffixStartInd - 1) >= 0 && !StringUtil.containsChar((String)".-_", (char)fileName.charAt(delimInd))) {
            return false;
        }
        return !StringUtil.contains((CharSequence)fileName, (CharSequence)"karma");
    }

    private static int findSuffixStartInd(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/protractor/ProtractorUtil", "findSuffixStartInd"));
        }
        for (String suffix : SUFFIXES_WITHOUT_FIRST_CHAR) {
            int ind = fileName.length() - suffix.length() - 1;
            if (ind < 0 || !StringUtil.charsEqualIgnoreCase((char)fileName.charAt(ind), (char)'c') || !StringUtil.endsWith((CharSequence)fileName, (CharSequence)suffix)) continue;
            return ind;
        }
        return -1;
    }

    public static boolean isProtractorConfigFile(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/protractor/ProtractorUtil", "isProtractorConfigFile"));
        }
        return StringUtil.startsWith((CharSequence)fileName, (CharSequence)PACKAGE_NAME) && StringUtil.endsWith((CharSequence)fileName, (CharSequence)"conf.js");
    }

    @NotNull
    public static ProtractorRunSettings readXml(Element element) {
        ProtractorRunSettings.Builder builder = ProtractorRunSettings.builder();
        String configFilePath = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG__CONFIG_FILE);
        builder.setConfigFilePath(StringUtil.notNullize((String)configFilePath));
        String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(interpreterRefName == null ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create(interpreterRefName));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        ProtractorRunSettings protractorRunSettings = builder.build();
        if (protractorRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "readXml"));
        }
        return protractorRunSettings;
    }

    public static void writeXml(@NotNull Element element, @NotNull ProtractorRunSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/protractor/ProtractorUtil", "writeXml"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/protractor/ProtractorUtil", "writeXml"));
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)TAG__CONFIG_FILE, (String)FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)TAG__NODE_INTERPRETER, (String)settings.getInterpreterRef().getReferenceName());
        settings.getEnvData().writeExternal(element);
    }

    public static void setProtractorPackage(@NotNull Project project, @NotNull NodePackage protractorPackage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "setProtractorPackage"));
        }
        if (protractorPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protractorPackage", "com/intellij/javascript/protractor/ProtractorUtil", "setProtractorPackage"));
        }
        ProtractorUtil.setProtractorPackagePath(project, protractorPackage.getSystemIndependentPath());
    }

    @NotNull
    public static NodePackage getProtractorPackage(@NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter, boolean detectIfEmpty) {
        NodePackage defaultPackage;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorPackage"));
        }
        String packagePath = ProtractorUtil.getProtractorPackagePath(project);
        if (detectIfEmpty && StringUtil.isEmpty((String)packagePath) && (defaultPackage = NodePackage.findDefaultPackage(project, PACKAGE_NAME, interpreter)) != null && StringUtil.isNotEmpty((String)defaultPackage.getSystemDependentPath().trim())) {
            ProtractorUtil.setProtractorPackagePath(project, defaultPackage.getSystemIndependentPath());
            NodePackage nodePackage = defaultPackage;
            if (nodePackage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorPackage"));
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorPackage"));
        }
        return nodePackage;
    }

    private static void setProtractorPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "setProtractorPackagePath"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/protractor/ProtractorUtil", "setProtractorPackagePath"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__PROTRACTOR_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getProtractorPackagePath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorPackagePath"));
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__PROTRACTOR_PACKAGE_DIR);
    }

    @NotNull
    public static File getProtractorMainJsFile(@NotNull NodePackage protractorPackage) {
        if (protractorPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protractorPackage", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorMainJsFile"));
        }
        File file = new File(protractorPackage.getSystemDependentPath(), "bin/protractor");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorUtil", "getProtractorMainJsFile"));
        }
        return file;
    }
}

