/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.actions.CompatibleRunConfigurationProducer;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsTestRunConfigurationProducer<T extends RunConfiguration>
extends CompatibleRunConfigurationProducer<T> {
    private static final VolatileNotNullLazyValue<List<String>> TEST_RUNNER_PACKAGES = VolatileNotNullLazyValue.createValue(() -> {
        ArrayList testRunnerPackages = ContainerUtil.newArrayList();
        for (RunConfigurationProducer producer : (RunConfigurationProducer[])EP_NAME.getExtensions()) {
            if (!(producer instanceof JsTestRunConfigurationProducer)) continue;
            testRunnerPackages.addAll(((JsTestRunConfigurationProducer)producer).myTestRunnerPackageNames);
        }
        return testRunnerPackages;
    });
    private static final Key<CachedValue<Boolean>> KEY = Key.create((String)JsTestRunConfigurationProducer.class.getSimpleName());
    private final List<String> myTestRunnerPackageNames;

    protected JsTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull List<String> testRunnerPackageNames) {
        if (configurationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationType", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "<init>"));
        }
        if (testRunnerPackageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnerPackageNames", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "<init>"));
        }
        super(configurationType);
        this.myTestRunnerPackageNames = ImmutableList.copyOf(testRunnerPackageNames);
    }

    public boolean isTestRunnerPackageAvailableFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "isTestRunnerPackageAvailableFor"));
        }
        return this.isTestRunnerPackageAvailableFor(element.getProject(), PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    public boolean isTestRunnerPackageAvailableFor(@NotNull Project project, @Nullable VirtualFile fileOrDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "isTestRunnerPackageAvailableFor"));
        }
        return JsTestRunConfigurationProducer.hasAnyPackageDeclaredAsDependency(project, fileOrDir, this.myTestRunnerPackageNames);
    }

    private static boolean hasAnyPackageDeclaredAsDependency(@NotNull Project project, @Nullable VirtualFile fileOrDir, @NotNull List<String> packages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "hasAnyPackageDeclaredAsDependency"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "hasAnyPackageDeclaredAsDependency"));
        }
        Ref foundRef = Ref.create((Object)false);
        if (fileOrDir != null) {
            PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<VirtualFile>)((Processor)packageJson -> {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "lambda$hasAnyPackageDeclaredAsDependency$1"));
                }
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                for (String pkg : packages) {
                    if (!data.isDependencyOfAnyType(pkg)) continue;
                    foundRef.set((Object)true);
                    break;
                }
                return (Boolean)foundRef.get() == false;
            }));
        }
        return (Boolean)foundRef.get();
    }

    public static boolean isTestRunnerPackageAvailableFor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "isTestRunnerPackageAvailableFor"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, KEY, () -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/testing/JsTestRunConfigurationProducer", "lambda$isTestRunnerPackageAvailableFor$2"));
            }
            boolean result = JsTestRunConfigurationProducer.hasAnyPackageDeclaredAsDependency(psiFile.getProject(), PsiUtilCore.getVirtualFile((PsiElement)psiFile), (List)TEST_RUNNER_PACKAGES.getValue());
            return new CachedValueProvider.Result((Object)result, new Object[]{VirtualFileManager.getInstance()});
        });
    }
}

