/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6GenerateIndexAction
extends AnAction {
    public ES6GenerateIndexAction() {
        super(JSBundle.message((String)"es6.generate.index.action", (Object[])new Object[0]), JSBundle.message((String)"es6.generate.index.action.description", (Object[])new Object[0]), null);
    }

    @Nullable
    private static VirtualFile getCurrentFileFromEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getCurrentFileFromEditor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @NotNull
    protected VirtualFile[] getDirectories(@Nullable DataContext dataContext) {
        if (dataContext == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getDirectories"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile file = ES6GenerateIndexAction.getCurrentFileFromEditor(dataContext);
        if (file != null) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{file.getParent()};
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getDirectories"));
            }
            return virtualFileArray;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getDirectories"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        for (VirtualFile virtualFile : files) {
            if (virtualFile.isDirectory()) continue;
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getDirectories"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (files == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "getDirectories"));
        }
        return files;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "update"));
        }
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile[] directories = this.getDirectories(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(directories.length > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile[] directories = this.getDirectories(e.getDataContext());
        if (directories.length == 0) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile directory : directories) {
            this.processDirectory(directory, manager);
        }
    }

    protected void processDirectory(@NotNull VirtualFile directory, PsiManager manager) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "processDirectory"));
        }
        ArrayList jsFiles = ContainerUtil.newArrayList();
        ArrayList tsFiles = ContainerUtil.newArrayList();
        boolean allDefinitions = true;
        for (VirtualFile file : directory.getChildren()) {
            DialectOptionHolder holder;
            JSFile jsFile;
            PsiFile psiFile = manager.findFile(file);
            if (!(psiFile instanceof JSFile) || !(jsFile = (JSFile)psiFile).isCommonJSModule() || (holder = DialectDetector.dialectOfFile(psiFile)) == null) continue;
            if (holder.isTypeScript) {
                tsFiles.add(jsFile);
                if (TypeScriptUtil.isDefinitionFile(file)) continue;
                allDefinitions = false;
                continue;
            }
            if (!holder.isECMA6) continue;
            jsFiles.add(jsFile);
        }
        PsiDirectory psiDirectory = manager.findDirectory(directory);
        if (psiDirectory == null) {
            return;
        }
        if (!tsFiles.isEmpty()) {
            this.generateIndex(psiDirectory, "index" + (allDefinitions ? ".d.ts" : ".ts"), tsFiles);
            return;
        }
        this.generateIndex(psiDirectory, "index.js", jsFiles);
    }

    protected void generateIndex(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull Collection<JSFile> files) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "generateIndex"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "generateIndex"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "generateIndex"));
        }
        PsiFile oldFile = directory.findFile(fileName);
        if (oldFile != null) {
            return;
        }
        final PsiFile file = (PsiFile)WriteAction.compute(() -> {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "lambda$generateIndex$0"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction", "lambda$generateIndex$0"));
            }
            return directory.createFile(fileName);
        });
        if (!(file instanceof JSFile)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        Project project = directory.getProject();
        for (JSFile jsFile : files) {
            String pathText = ES6GenerateIndexAction.getModuleName(file, project, jsFile);
            if (pathText == null) continue;
            builder.append("export * from ").append(pathText).append(JSCodeStyleSettings.getSemicolon(file)).append("\n");
        }
        if (builder.length() > 0) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)file);
            final PsiFile newFile = JSChangeUtil.createJSFileFromText(project, builder.toString(), dialect);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)newFile);
            new WriteCommandAction.Simple<Void>(project, JSBundle.message((String)"es6.generate.index.action", (Object[])new Object[0]), new PsiFile[]{file}){

                protected void run() throws Throwable {
                    file.addRange(newFile.getFirstChild(), newFile.getLastChild());
                }
            }.execute();
        }
        FileEditorManager.getInstance((Project)project).openFile(file.getVirtualFile(), true);
    }

    @Nullable
    private static String getModuleName(PsiFile file, Project project, JSFile jsFile) {
        if (!DialectDetector.isTypeScript((PsiElement)file)) {
            String quote = JSCodeStyleSettings.getQuote((PsiElement)file);
            return quote + "./" + jsFile.getVirtualFile().getNameWithoutExtension() + quote;
        }
        TypeScriptConfig configFile = TypeScriptConfigUtil.getConfigForPsiFile(file);
        TypeScriptAutoImportUtil.ModuleInfo info = TypeScriptAutoImportUtil.getExternalModuleNameForFile(project, configFile, file.getVirtualFile(), file, jsFile.getVirtualFile(), (PsiElement)file, false);
        if (info == null) {
            return null;
        }
        return info.getPath();
    }
}

