/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessorBase;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});
    public static final String DEFAULT_NAME = "default";

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
            }
            return arrayList;
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull JSElement scopeElement) {
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findDefaultExport"));
        }
        Stream<? extends PsiElement> stream = JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream((PsiElement)scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, ES6ExportDefaultAssignment.class);
        Optional<? extends PsiElement> exportDefaultAssignment = stream.findAny();
        if (exportDefaultAssignment.isPresent()) {
            return (JSElement)exportDefaultAssignment.get();
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1", "execute"));
                }
                if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportSpecifier || element instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element);
                    return false;
                }
                return true;
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scopeElement, processor, false);
        PsiElement result = (PsiElement)resultElement.get();
        if (!(result instanceof JSElement)) {
            return null;
        }
        if (result instanceof ES6ExportSpecifier) {
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result).multiResolve(false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            return item instanceof JSElement ? (JSElement)item : null;
        }
        return (JSElement)result;
    }

    public static boolean isAsyncContext(@Nullable JSFunction function) {
        if (function == null) {
            return false;
        }
        JSAttributeList attributeList = function.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    @Contract(value="null -> false")
    public static boolean isAwaitExpression(@Nullable PsiElement expression) {
        JSPrefixExpression prefixExpression;
        JSPrefixExpression jSPrefixExpression = prefixExpression = expression instanceof JSPrefixExpression ? (JSPrefixExpression)expression : null;
        if (prefixExpression != null) {
            return prefixExpression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
        }
        return false;
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull JSElement owner, PsiElement place, @NotNull JSModuleElementsProcessor processor, Collection<PsiElement> visited) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (!ES6PsiUtil.isExternalModule((PsiElement)owner)) {
            return true;
        }
        PsiElement[] children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS);
        if (children == null) {
            return true;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, null, ResolveState.initial(), (PsiElement)element.getContainingFile(), place, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getFromClauseResolvedReferences"));
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            result.addAll(typeResolveResult.getElements());
        }
        return result;
    }

    @NotNull
    public static List<JSType> processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink) {
        JSElement scope;
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (declaration == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        List innerAliases = null;
        if (clause != null) {
            Collection<PsiElement> scopes = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement scope2 : scopes) {
                QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(specifier, scope2, sink);
                JSDelegatingModuleElementsProcessor delegatingProcessor = new JSDelegatingModuleElementsProcessor(processor);
                ES6PsiUtil.processSpecifierForScope(specifier, delegatingProcessor, scope2);
                innerAliases = delegatingProcessor.myInnerAliases;
            }
        } else if (specifier instanceof ES6ExportSpecifier && (scope = ES6PsiUtil.getExportScope((PsiElement)specifier)) != null) {
            final QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(specifier, (PsiElement)scope, sink);
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                    }
                    if (element instanceof ES6ExportSpecifier || element instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element, state);
                }
            };
            JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor, ResolveState.initial(), (PsiElement)scope.getContainingFile(), (PsiElement)specifier);
        }
        List list = innerAliases != null ? innerAliases : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        return list;
    }

    private static boolean processSpecifierForScope(@NotNull ES6ImportExportSpecifier specifier, @NotNull JSModuleElementsProcessor processor, PsiElement scope) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifierForScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifierForScope"));
        }
        if (!(scope instanceof JSElement)) {
            return true;
        }
        if (scope instanceof JSVariable) {
            JSType possibleType = ((JSVariable)scope).getType();
            if (possibleType != null) {
                processor.process(possibleType, new JSEvaluateContext(scope.getContainingFile()), scope);
            }
            return true;
        }
        return ES6PsiUtil.processExportDeclarationInScope((JSElement)scope, processor, ResolveState.initial(), (PsiElement)specifier);
    }

    public static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull ES6ImportExportSpecifier specifier, @NotNull PsiElement scope, @NotNull ResultSink sink) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope).createCompletionItemProcessor(sink, specifier.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    public static void addInnerAliases(@NotNull List<JSType> innerAliases, @NotNull BaseJSSymbolProcessor processor) {
        if (innerAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerAliases", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addInnerAliases"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addInnerAliases"));
        }
        for (JSType type : innerAliases) {
            JSNamespaceEvaluationResult ns = JSNamespaceEvaluationResult.fromType(type);
            PsiFile scope = type.getSource().getScope();
            if (ns == null) continue;
            processor.addTypeHierarchy(ns, scope);
        }
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getExportScope"));
        }
        return element instanceof PsiFile ? null : (JSElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    @Nullable
    public static PsiElement getNonStrictExportScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getNonStrictExportScope"));
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope, processor, null, state, null, place, null);
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull JSModuleElementsProcessor processor, @Nullable JSEvaluationResultContext evaluateContext, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @Nullable Collection<PsiElement> visited) {
        boolean isES6Module;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (visited != null && !visited.add((PsiElement)scope)) {
            return false;
        }
        boolean hasIncompleteMatch = false;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)scope);
        if (scope instanceof JSFile && !isTypeScript && ES6PsiUtil.isEmptyContext(evaluateContext)) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)((JSFile)scope));
            QualifiedItemProcessor resolveProcessor = processor instanceof ResolveProcessor ? (QualifiedItemProcessor)processor : (processor instanceof JSDelegatingModuleElementsProcessor ? ((JSDelegatingModuleElementsProcessor)processor).myDelegate : null);
            boolean processingFromIndices = false;
            if (resolveProcessor != null) {
                processingFromIndices = resolveProcessor.isProcessingFromIndices();
                resolveProcessor.setSkipImplicitDeclarations(true);
            }
            Processor namespaceMembersProcessor = element -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$processExportDeclarationInScope$0"));
                }
                if (resolveProcessor != null && resolveProcessor.getName() == null && (element.getAccessType() == JSAttributeList.AccessType.PRIVATE || JSVisibilityUtil.seemsToBePrivateSymbol(element.getName()))) {
                    return true;
                }
                return processor.execute((PsiElement)element, ResolveState.initial());
            };
            JSClassResolver.getInstance().processNamespaceMembers("exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            JSClassResolver.getInstance().processNamespaceMembers("module.exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            if (resolveProcessor != null) {
                resolveProcessor.setSkipImplicitDeclarations(processingFromIndices);
            }
        }
        if (scope instanceof JSFile && !isTypeScript) {
            JSType exportsInnerAlias = ((JSFile)scope).getExportsInnerAlias();
            if (exportsInnerAlias != null) {
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                HashSet _visited = visited;
                JSApplyContextUtil.applyTypeToContext(exportsInnerAlias, evaluateContext, (newType, newContext) -> {
                    if (scope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$processExportDeclarationInScope$2"));
                    }
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$processExportDeclarationInScope$2"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$processExportDeclarationInScope$2"));
                    }
                    JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)typeComponent -> {
                        if (scope == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$null$1"));
                        }
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$null$1"));
                        }
                        if (place == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$null$1"));
                        }
                        if (typeComponent instanceof JSRequireCallExpressionType) {
                            String referencedModule = ((JSRequireCallExpressionType)((Object)((Object)typeComponent))).getReferencedModule();
                            Collection<PsiElement> reexportedModules = JSFileReferencesUtil.resolveModuleReference((PsiFile)((JSFile)scope), referencedModule);
                            for (PsiElement reexportedModule : reexportedModules) {
                                if (!(reexportedModule instanceof JSElement)) continue;
                                ES6PsiUtil.processExportDeclarationInScope((JSElement)reexportedModule, processor, newContext, ResolveState.initial(), (PsiElement)reexportedModule.getContainingFile(), place, _visited);
                            }
                        }
                        return true;
                    }), newType);
                });
                JSEvaluateContext context = evaluateContext != null ? JSEvaluateContext.fromEvaluationResultContext(evaluateContext) : new JSEvaluateContext((PsiFile)scope);
                processor.process(exportsInnerAlias, context, (PsiElement)scope);
            }
            hasIncompleteMatch = exportsInnerAlias != null || !((JSFile)scope).hasES6Syntax();
        }
        ES6ExportedElementsProcessor exportedElementsProcessor = processor instanceof ES6ExportedElementsProcessor ? (ES6ExportedElementsProcessor)((Object)processor) : new ES6ExportedElementsProcessor(processor);
        boolean result = true;
        boolean bl = isES6Module = isTypeScript || scope instanceof JSFile && ((JSFile)scope).hasES6Syntax();
        if (isES6Module && ES6PsiUtil.isEmptyContext(evaluateContext)) {
            boolean bl2 = result = isTypeScript ? JSResolveUtil.processDeclarationsInScope(scope, exportedElementsProcessor, state, lastParent, place) : JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, exportedElementsProcessor, false);
            if (result) {
                ES6PsiUtil.processExportAllDeclarations(scope, place, processor, visited);
            }
            if (result && DialectDetector.isTypeScript((PsiElement)scope) && processor.getName() != null) {
                QualifiedItemProcessor sinkProcessor;
                QualifiedItemProcessor qualifiedItemProcessor = processor instanceof SinkResolveProcessor ? (QualifiedItemProcessor)processor : (sinkProcessor = processor instanceof JSDelegatingModuleElementsProcessor ? ((JSDelegatingModuleElementsProcessor)processor).myDelegate : null);
                if (sinkProcessor != null && ((ResultSink)sinkProcessor.getResultSink()).getResultCount() == 0) {
                    TypeScriptResolveHelper.processGlobalThings(sinkProcessor, ResolveState.initial(), (PsiElement)scope);
                }
            }
        }
        return hasIncompleteMatch || result;
    }

    private static boolean isEmptyContext(@Nullable JSEvaluationResultContext evaluateContext) {
        return evaluateContext == null || evaluateContext.isJSElementsToApplyEmpty() || evaluateContext.getJSElementsToApply().size() == 1 && evaluateContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement;
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportSpecifierAlias || item instanceof TypeScriptImportStatement;
    }

    @Deprecated
    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        return JSFileReferencesUtil.createImportExportFromClauseReferences(host, offset, text, provider);
    }

    public static boolean isElementCanBeExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "isElementCanBeExported"));
        }
        return element instanceof JSAttributeListOwner && !(element instanceof TypeScriptTypeMember) && !(element instanceof JSParameter) && !(element instanceof JSProperty) && !(element instanceof JSField) && !(element instanceof TypeScriptType);
    }

    public static boolean isExternalModule(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "isExternalModule"));
        }
        if (element instanceof JSFile) {
            return ((JSFile)element).getModuleStatus() == JSFile.ModuleStatus.ES6;
        }
        return element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal();
    }

    private static class JSDelegatingModuleElementsProcessor
    extends JSQualifiedItemProcessorBase
    implements JSModuleElementsProcessor {
        @NotNull
        private final List<JSType> myInnerAliases;
        @NotNull
        private final QualifiedItemProcessor<?> myDelegate;

        public JSDelegatingModuleElementsProcessor(@NotNull QualifiedItemProcessor<?> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor", "<init>"));
            }
            this.myInnerAliases = new SmartList();
            this.myDelegate = delegate;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor", "execute"));
            }
            return this.myDelegate.execute(element, state);
        }

        @Override
        @Nullable
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor", "process"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor", "process"));
            }
            this.myDelegate.process(type, evaluateContext, source);
            this.myInnerAliases.add(type);
        }

        @Override
        public void executeCandidateResult(PsiElement element, String s) {
            this.myDelegate.executeCandidateResult(element, s);
        }
    }

    public static class ES6ExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public ES6ExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateProcessor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor", "<init>"));
            }
            super(delegateProcessor instanceof JSResolveProcessor ? ((JSResolveProcessor)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor", "execute"));
            }
            if (element instanceof ES6ExportSpecifier) {
                ResolveResult[] results;
                ES6ImportExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                for (ResolveResult result : results = ((ES6ExportSpecifier)element).multiResolve(false)) {
                    PsiElement resultElement;
                    if (!result.isValidResult() || (resultElement = result.getElement()) == null || this.myDelegate.execute(resultElement, state)) continue;
                    return false;
                }
            } else {
                if (ES6ImportHandler.isExported(element)) {
                    return this.myDelegate.execute(element, state);
                }
                if (this.myDelegate instanceof JSCandidateResultProcessor) {
                    ((JSCandidateResultProcessor)this.myDelegate).executeCandidateResult(element, "javascript.element.need.to.be.exported");
                }
            }
            return true;
        }
    }
}

