/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSLanguageLevelPusher;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JavaScriptDialectFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialectDetector {
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = new FileType[]{JavaScriptSupportLoader.JAVASCRIPT, ES6FileType.INSTANCE, JSXHarmonyFileType.INSTANCE, FlowJSFileType.INSTANCE};
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])JAVASCRIPT_FILE_TYPES_ARRAY);
    private static final Key<ParameterizedCachedValue<JSLanguageDialect, PsiFile>> KEY_DIALECT_HOLDER = Key.create((String)"JavaScript.Dialect.Holder");
    private static final ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile> PROVIDER = new ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<JSLanguageDialect> compute(PsiFile file) {
            return CachedValueProvider.Result.create((Object)((Object)DialectDetector.dialectOfFileNoCache(file)), (Object[])new Object[]{file});
        }
    };

    @Nullable
    public static DialectOptionHolder dialectOfElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).getOptionHolder() : null;
    }

    @Nullable
    public static DialectOptionHolder dialectOfFile(@Nullable PsiFile file) {
        return DialectDetector.dialectOfElement((PsiElement)file);
    }

    @Nullable
    private static JSLanguageDialect dialectOfFileNoCache(@NotNull PsiFile file) {
        JSLanguageDialect dialect;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "dialectOfFileNoCache"));
        }
        Language language = file.getLanguage();
        if (language instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        if (language == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (JavaScriptSupportLoader.isMxmlOrFxgFile(file)) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        VirtualFile virtualFile2 = virtualFile = virtualFile == null ? (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)file) : virtualFile;
        if (virtualFile != null && ("swf".equalsIgnoreCase(virtualFile.getExtension()) || "swc".equalsIgnoreCase(virtualFile.getExtension()))) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null && (dialect = DialectDetector.getLanguageDialect(virtualFile, file.getProject())) != null) {
            return dialect;
        }
        return null;
    }

    @NotNull
    public static Language languageOfElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
        }
        if (element instanceof PsiFile) {
            Language language = DialectDetector.languageOfFile((PsiFile)element);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
            }
            return language;
        }
        if (element instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
            }
            return jSLanguageDialect;
        }
        if (element instanceof JSPackageWrapper) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
            }
            return jSLanguageDialect;
        }
        PsiElement parent = element.getContext();
        if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl) {
            Language language = parent.getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
            }
            return language;
        }
        if (element instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            PsiFile file = element.getContainingFile();
            Language language = file instanceof JSFile ? DialectDetector.languageOfFile(file) : JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element).getElementType(), element.getProject());
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
            }
            return language;
        }
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)parent, (boolean)false, (Class[])new Class[]{JSEmbeddedContent.class, PsiFile.class});
        Language language = context instanceof PsiFile ? DialectDetector.languageOfFile((PsiFile)context) : (context != null ? context.getLanguage() : element.getLanguage());
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfElement"));
        }
        return language;
    }

    @NotNull
    private static Language languageOfFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "languageOfFile"));
        }
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, KEY_DIALECT_HOLDER, PROVIDER, false, (Object)file));
        JSLanguageDialect jSLanguageDialect = dialect != null ? dialect : file.getLanguage();
        if (jSLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "languageOfFile"));
        }
        return jSLanguageDialect;
    }

    @Nullable
    public static JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "languageDialectOfElement"));
        }
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    public static boolean isTypeScript(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isTypeScript"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isTypeScript;
    }

    public static boolean isTypeScriptDefinitionFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "isTypeScriptDefinitionFile"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile(file);
        return holder != null && holder.isTypeScript && TypeScriptUtil.isDefinitionFile(file.getName());
    }

    public static boolean isActionScript(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isActionScript"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect == DialectOptionHolder.ECMA_4;
    }

    public static boolean isJavaScript(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isJavaScript"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect == null || dialect.isJavaScript();
    }

    public static boolean isJavaScriptFamily(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isJavaScriptFamily"));
        }
        return !DialectDetector.isActionScript(element);
    }

    public static boolean isES6(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isES6"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isECMA6;
    }

    public static boolean isJSX(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/DialectDetector", "isJSX"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isJSX;
    }

    @NotNull
    public static Language getJSLanguage(@NotNull VirtualFile file) {
        Language language;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "getJSLanguage"));
        }
        FileType type = file.getFileType();
        Language language2 = language = type instanceof LanguageFileType ? ((LanguageFileType)type).getLanguage() : null;
        Object object = JavaScriptSupportLoader.GWT_DIALECT.getFileExtension().equals(file.getExtension()) ? JavaScriptSupportLoader.GWT_DIALECT : (language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/DialectDetector", "getJSLanguage"));
        }
        return object;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "getLanguageDialect"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/DialectDetector", "getLanguageDialect"));
        }
        JSLanguageDialect jsDialect = DialectDetector.getLanguageDialectForJSFile(file, project);
        if (jsDialect != null) {
            return jsDialect;
        }
        Language language = DialectDetector.getJSLanguage(file);
        if (language instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/DialectDetector", "getLanguageDialectForJSFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/DialectDetector", "getLanguageDialectForJSFile"));
        }
        FileType type = file.getFileType();
        if (JAVASCRIPT_FILE_TYPES.contains(type)) {
            JSLanguageLevel configuredLevel;
            VirtualFile originalFile;
            if (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
                file = originalFile;
            }
            if ((configuredLevel = (JSLanguageLevel)((Object)JSLanguageLevelPusher.KEY.get((UserDataHolder)file.getParent()))) == null) {
                if (JSRootConfiguration.getInstance(project) == null) {
                    return null;
                }
                configuredLevel = JSRootConfiguration.getInstance(project).getLanguageLevel();
            }
            if (type instanceof JavaScriptDialectFileType) {
                JSLanguageDialect language = ((JavaScriptDialectFileType)type).getDefaultLanguage();
                DialectOptionHolder defaultLevelHolder = language.getOptionHolder();
                if (!configuredLevel.getDialect().getOptionHolder().isAtLeast(defaultLevelHolder)) {
                    return language;
                }
            }
            return configuredLevel.getDialect();
        }
        return null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/DialectDetector", "getLanguageDialect"));
        }
        return DialectDetector.languageDialectOfElement(psi);
    }
}

