/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean myAllowUnicodeEscapesWithinBraces;

    public JSStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces) {
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.myAllowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myAllowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            char c;
            int i;
            boolean foundHex = false;
            for (i = this.myStart + 3; i < this.myEnd && StringUtil.isHexDigit((char)(c = this.myBuffer.charAt(i))); ++i) {
                foundHex = true;
            }
            IElementType iElementType = foundHex && i < this.myEnd && this.myBuffer.charAt(i) == '}' ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSStringLiteralLexer", "getUnicodeEscapeSequenceType"));
            }
            return iElementType;
        }
        IElementType iElementType = super.getUnicodeEscapeSequenceType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSStringLiteralLexer", "getUnicodeEscapeSequenceType"));
        }
        return iElementType;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        if (this.myAllowUnicodeEscapesWithinBraces && ++i < this.myBufferEnd && this.myBuffer.charAt(i) == '{') {
            ++i;
            while (i < this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return i;
        }
        while (i < start + 6) {
            if (i == this.myBufferEnd || this.myBuffer.charAt(i) == '\n' || this.myBuffer.charAt(i) == this.myQuoteChar) {
                return i;
            }
            ++i;
        }
        return i;
    }
}

