/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebStormDiagramsConfigurator
implements StartupActivity {
    public static final String SHOW_UML_DIAGRAM = "ShowUmlDiagram";
    public static final String UML_GROUP_SIMPLE = "UML.Group.Simple";
    public static final String UML_GROUP = "UML.Group";
    public static final String SHOW_UML_DIAGRAM_POPUP = "ShowUmlDiagramPopup";
    @NonNls
    private static final Set<String> KEEP = ContainerUtil.set((Object[])new String[]{"ShowUmlDiagram", "UML.Group", "UML.Group.Simple", "ShowUmlDiagramPopup"});
    @NonNls
    private static final String[] REMOVE_ACTIONS = new String[]{"UML.Group.Simple", "UML.Group", "Uml.NewGroup", "Uml.ShowDiff", "ShowUmlDiagram", "ShowUmlDiagramPopup", "UML.ShowChanges"};
    private static volatile boolean ourWorkDone;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/WebStormDiagramsConfigurator", "runActivity"));
        }
        if (!"WebStorm".equals(System.getProperty("idea.platform.prefix", "")) || ourWorkDone) {
            return;
        }
        WebStormDiagramsConfigurator.removeDiagramActions(ActionManager.getInstance(), Registry.is((String)"WebStorm.JavaScript.Modules.Diagram"));
        ourWorkDone = true;
    }

    private static void removeDiagramActions(ActionManager actionManager, boolean keepShowDiagram) {
        DiagramProvider[] extensions;
        AbbreviationManager abbreviationManager = AbbreviationManager.getInstance();
        for (String actionId : REMOVE_ACTIONS) {
            if (keepShowDiagram && KEEP.contains(actionId)) continue;
            Set abbreviations = abbreviationManager.getAbbreviations(actionId);
            for (String abbreviation : abbreviations) {
                abbreviationManager.remove(abbreviation, actionId);
            }
        }
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "VcsHistoryActionsGroup", "Uml.ShowDiff");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "VcsGlobalGroup", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "ChangesViewToolbar", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, "UML.EditorGroup", "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, UML_GROUP, "UML.ShowChanges");
        WebStormDiagramsConfigurator.removeFromGroup(actionManager, UML_GROUP_SIMPLE, "UML.ShowChanges");
        for (String actionId : REMOVE_ACTIONS) {
            ActionGroup group;
            AnAction action;
            if (keepShowDiagram && KEEP.contains(actionId) || (action = actionManager.getAction(actionId)) == null) continue;
            if (actionManager.isGroup(actionId) && (group = (ActionGroup)action) instanceof DefaultActionGroup) {
                ((DefaultActionGroup)group).removeAll();
            }
            actionManager.unregisterAction(actionId);
        }
        for (DiagramProvider extension : extensions = (DiagramProvider[])DiagramProvider.DIAGRAM_PROVIDER.getExtensions()) {
            if (!"DiffUmlProvider".equals(extension.getClass().getSimpleName())) continue;
            Extensions.getRootArea().getExtensionPoint(DiagramProvider.DIAGRAM_PROVIDER).unregisterExtension((Object)extension);
        }
    }

    private static void removeFromGroup(@NotNull ActionManager actionManager, @NotNull String groupId, @NotNull String actionId) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/lang/javascript/WebStormDiagramsConfigurator", "removeFromGroup"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/lang/javascript/WebStormDiagramsConfigurator", "removeFromGroup"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/lang/javascript/WebStormDiagramsConfigurator", "removeFromGroup"));
        }
        AnAction action = actionManager.getAction(actionId);
        if (action == null) {
            return;
        }
        DefaultActionGroup changesViewToolbar = (DefaultActionGroup)actionManager.getAction(groupId);
        changesViewToolbar.getChildren(null);
        changesViewToolbar.remove(action);
    }
}

