/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSShowTypeInfoAction
extends JSShowTypeInfoAction {
    @Override
    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        Project project = element.getProject();
        if (FlowJSShowTypeInfoAction.useService(project)) {
            FlowJSConfig config;
            PsiFile file = element.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            FlowJSServerService service = FlowJSServerService.getService(project);
            if (service != null && (config = service.getConfig(virtualFile)) != null) {
                FlowJSServerService.saveSyncAllUnsavedFiles(file);
                Document document = file.getViewProvider().getDocument();
                if (document != null) {
                    String string = service.getTypeOfElement(element, virtualFile, document, config);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
                    }
                    return string;
                }
            }
        }
        String string = element instanceof JSElement ? super.getInformationHint(element) : "<unknown>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getErrorHint"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        if (FlowJSShowTypeInfoAction.useService(elementAt.getProject())) {
            List<PsiElement> list = Collections.singletonList(elementAt);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
            }
            return list;
        }
        List<PsiElement> list = super.getExpressionsAt(elementAt);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        return list;
    }

    private static boolean useService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "useService"));
        }
        return FlowJSServerService.getService(project) != null && FlowJSSettingsManager.getInstance(project).getFlowSettings().isOtherServicesEnabled();
    }
}

