/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerPackagesView;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerValidationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerView {
    private final Project myProject;
    private final JPanel myComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myBowerExecutableCombobox;
    private final TextFieldWithBrowseButton myBowerJsonField;
    private final BowerPackagesView myPackagesView;
    private final List<Pair<JTextField, String>> myValidationList;
    private final Color myNormalForeground;
    private volatile boolean myTrackChanges;

    public BowerView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerView", "<init>"));
        }
        this.myTrackChanges = true;
        this.myProject = project;
        this.myBowerExecutableCombobox = BowerView.createBowerExecutable(project);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myBowerJsonField = BowerView.createBowerJsonField(project);
        this.myPackagesView = new BowerPackagesView(project);
        this.myValidationList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)((TextFieldWithHistory)this.myBowerExecutableCombobox.getChildComponent()).getTextEditor(), (Object)"Bower executable"), Pair.create((Object)this.myBowerJsonField.getChildComponent(), (Object)"bower.json")});
        this.myNormalForeground = ((JTextField)this.myBowerJsonField.getChildComponent()).getForeground();
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent("&Bower executable:", (JComponent)this.myBowerExecutableCombobox).addLabeledComponent("b&ower.json:", (JComponent)this.myBowerJsonField).getPanel();
        this.myNodeInterpreterField.addChangeListener(new NodeJsInterpreterChangeListener(){

            @Override
            public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                if (BowerView.this.myTrackChanges) {
                    BowerView.this.updateLaterInEDT();
                }
            }
        });
        this.listenForChanges(this.myBowerExecutableCombobox);
        this.listenForChanges((JTextComponent)this.myBowerJsonField.getChildComponent());
        this.myComponent = BowerView.createResult(panel, this.myPackagesView.getComponent());
    }

    private static JPanel createResult(@NotNull JComponent top, @NotNull JComponent bottom) {
        if (top == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "top", "com/intellij/lang/javascript/bower/BowerView", "createResult"));
        }
        if (bottom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bottom", "com/intellij/lang/javascript/bower/BowerView", "createResult"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bottom, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void listenForChanges(@NotNull TextFieldWithHistoryWithBrowseButton component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/bower/BowerView", "listenForChanges"));
        }
        this.listenForChanges(((TextFieldWithHistory)component.getChildComponent()).getTextEditor());
    }

    private void listenForChanges(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponent", "com/intellij/lang/javascript/bower/BowerView", "listenForChanges"));
        }
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (BowerView.this.myTrackChanges) {
                    BowerView.this.updateLaterInEDT();
                }
            }
        });
    }

    private void updateLaterInEDT() {
        UIUtil.invokeLaterIfNeeded(() -> this.update());
    }

    private void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        BowerSettings.Builder builder = new BowerSettings.Builder(this.myProject);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setBowerExecutablePath(StringUtil.notNullize((String)this.myBowerExecutableCombobox.getText()));
        builder.setBowerJsonPath(StringUtil.notNullize((String)((JTextField)this.myBowerJsonField.getChildComponent()).getText()));
        List<BowerValidationInfo> validationInfos = this.validate();
        this.myPackagesView.onSettingsChanged(builder.build(), validationInfos);
    }

    @NotNull
    private List<BowerValidationInfo> validate() {
        ArrayList infos = ContainerUtil.newArrayList();
        for (Pair<JTextField, String> pair : this.myValidationList) {
            JTextField textField = (JTextField)pair.getFirst();
            BowerValidationInfo info = BowerView.validateFilePathField(textField, textField.getText(), (String)pair.getSecond());
            this.processValidationInfo(infos, textField, info);
        }
        BowerValidationInfo info = this.validateNodeInterpreter();
        this.processValidationInfo(infos, (Component)((Object)this.myNodeInterpreterField), info);
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "validate"));
        }
        return arrayList;
    }

    private void processValidationInfo(@NotNull List<BowerValidationInfo> infos, @NotNull Component component, @Nullable BowerValidationInfo info) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/javascript/bower/BowerView", "processValidationInfo"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/bower/BowerView", "processValidationInfo"));
        }
        if (info != null) {
            infos.add(info);
        }
        if (component instanceof JTextComponent) {
            component.setForeground((Color)(info != null ? JBColor.RED : this.myNormalForeground));
        }
    }

    @Nullable
    private BowerValidationInfo validateNodeInterpreter() {
        NodeJsInterpreter interpreter = this.myNodeInterpreterField.getInterpreter();
        String nodeInterpreterErrorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (nodeInterpreterErrorMessage != null) {
            return new BowerValidationInfo((Component)((Object)this.myNodeInterpreterField), "Please correct path to {{LINK}}", "Node interpreter");
        }
        return null;
    }

    @Nullable
    private static BowerValidationInfo validateFilePathField(@NotNull Component component, @NotNull String path, @NotNull String exeFileType) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/bower/BowerView", "validateFilePathField"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/bower/BowerView", "validateFilePathField"));
        }
        if (exeFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exeFileType", "com/intellij/lang/javascript/bower/BowerView", "validateFilePathField"));
        }
        File file = new File(path);
        if (file.isFile()) {
            return null;
        }
        return new BowerValidationInfo(component, "Please correct path to {{LINK}}", exeFileType);
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createBowerExecutable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerView", "createBowerExecutable"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select Bower executable", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerView", "lambda$createBowerExecutable$1"));
            }
            return BowerView.calcPossibleBowerExecutableFiles(project);
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "createBowerExecutable"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static List<String> calcPossibleBowerExecutableFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerView", "calcPossibleBowerExecutableFiles"));
        }
        ArrayList paths = ContainerUtil.newArrayList();
        String basename = BowerCommandLineUtil.getBowerExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)basename);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)infos, "bower", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            File exe;
            File bowerPackageDir;
            String path = info.getAbsolutePath();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || path == null || !(bowerPackageDir = new File(FileUtil.toSystemDependentName((String)path))).isDirectory() || !(exe = new File(bowerPackageDir, "bin" + File.separator + basename)).isFile()) continue;
            paths.add(exe.getAbsolutePath());
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "calcPossibleBowerExecutableFiles"));
        }
        return arrayList;
    }

    @NotNull
    private static TextFieldWithBrowseButton createBowerJsonField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerView", "createBowerJsonField"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)"Select bower.json", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "createBowerJsonField"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = new BowerSettings.Builder(this.myProject).setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef()).setBowerExecutablePath(StringUtil.notNullize((String)this.myBowerExecutableCombobox.getText())).setBowerJsonPath(StringUtil.notNullize((String)this.myBowerJsonField.getText())).build();
        if (bowerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerView", "getSettings"));
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerView", "setSettings"));
        }
        this.myTrackChanges = false;
        try {
            this.myNodeInterpreterField.setInterpreterRef(settings.getInterpreterRef());
            this.myBowerExecutableCombobox.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)settings.getBowerExecutablePath()));
            this.myBowerJsonField.setText(FileUtil.toSystemDependentName((String)settings.getBowerJsonPath()));
            this.updateLaterInEDT();
        }
        finally {
            this.myTrackChanges = true;
        }
    }
}

