/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        VirtualFile oldBuildfile = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (oldBuildfile != null) {
            Project project = element.getProject();
            for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
                JsbtFileManager fileManager = service.getFileManager(project);
                if (oldBuildfile.isDirectory()) {
                    if (!JsbtRefactoringElementListenerProvider.areBuildfilesFilesInside(fileManager, oldBuildfile)) continue;
                    return new DirectoryRefactoringElementAdapter(oldBuildfile);
                }
                if (!fileManager.containsBuildfile(oldBuildfile)) continue;
                return new FileRefactoringElementAdapter(oldBuildfile);
            }
        }
        return null;
    }

    private static boolean areBuildfilesFilesInside(@NotNull JsbtFileManager manager, @NotNull VirtualFile dir) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "areBuildfilesFilesInside"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "areBuildfilesFilesInside"));
        }
        for (VirtualFile file : manager.getBuildfiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static void update(@NotNull Project project, @NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "update"));
        }
        if (oldBuildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "update"));
        }
        if (newBuildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "update"));
        }
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (!fileManager.containsBuildfile(oldBuildfile)) continue;
            fileManager.changeBuildfile(oldBuildfile, newBuildfile);
        }
    }

    private static void updateOnDirectoryRenameOrMove(@NotNull Project project, @NotNull VirtualFile newDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "updateOnDirectoryRenameOrMove"));
        }
        if (newDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDir", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "updateOnDirectoryRenameOrMove"));
        }
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            for (VirtualFile buildfile : fileManager.getBuildfiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)newDir, (VirtualFile)buildfile, (boolean)true)) continue;
                fileManager.changeBuildfile(buildfile, buildfile);
            }
        }
    }

    private static class FileRefactoringElementAdapter
    extends RefactoringElementAdapter {
        private final VirtualFile myOldBuildfile;

        public FileRefactoringElementAdapter(@NotNull VirtualFile oldBuildfile) {
            if (oldBuildfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$FileRefactoringElementAdapter", "<init>"));
            }
            this.myOldBuildfile = oldBuildfile;
        }

        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$FileRefactoringElementAdapter", "elementRenamedOrMoved"));
            }
            VirtualFile newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement);
            if (newBuildfile != null) {
                JsbtRefactoringElementListenerProvider.update(newElement.getProject(), this.myOldBuildfile, newBuildfile);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$FileRefactoringElementAdapter", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$FileRefactoringElementAdapter", "undoElementMovedOrRenamed"));
            }
            VirtualFile newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement);
            if (newBuildfile != null) {
                JsbtRefactoringElementListenerProvider.update(newElement.getProject(), newBuildfile, this.myOldBuildfile);
            }
        }
    }

    private static class DirectoryRefactoringElementAdapter
    extends RefactoringElementAdapter {
        private final VirtualFile myOldDir;

        public DirectoryRefactoringElementAdapter(@NotNull VirtualFile oldDir) {
            if (oldDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldDir", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$DirectoryRefactoringElementAdapter", "<init>"));
            }
            this.myOldDir = oldDir;
        }

        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$DirectoryRefactoringElementAdapter", "elementRenamedOrMoved"));
            }
            VirtualFile newDir = PsiUtilBase.asVirtualFile((PsiElement)newElement);
            if (newDir != null) {
                JsbtRefactoringElementListenerProvider.updateOnDirectoryRenameOrMove(newElement.getProject(), newDir);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$DirectoryRefactoringElementAdapter", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$DirectoryRefactoringElementAdapter", "undoElementMovedOrRenamed"));
            }
            VirtualFile newDir = PsiUtilBase.asVirtualFile((PsiElement)newElement);
            if (newDir != null) {
                JsbtRefactoringElementListenerProvider.updateOnDirectoryRenameOrMove(newElement.getProject(), this.myOldDir);
            }
        }
    }
}

