/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.base.PaddedIconBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtAddBuildfileAction
extends AnAction
implements DumbAware {
    private final JsbtService myService;

    public JsbtAddBuildfileAction(@NotNull JsbtService service, boolean popupPlace) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "<init>"));
        }
        super("Add " + service.getBuildfileCommonName());
        this.myService = service;
        this.getTemplatePresentation().setIcon(JsbtAddBuildfileAction.createIcon(JavaScriptLanguageIcons.BuildTools.Plus, popupPlace));
        this.getTemplatePresentation().setHoveredIcon(JsbtAddBuildfileAction.createIcon(JavaScriptLanguageIcons.BuildTools.Plus_hovered, popupPlace));
        this.setShortcutSet(CommonShortcuts.getNewForDialogs());
    }

    @NotNull
    private static Icon createIcon(@NotNull Icon icon, boolean popupPlace) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createIcon"));
        }
        if (!popupPlace) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createIcon"));
            }
            return icon2;
        }
        int verticalPadding = 6;
        Icon icon3 = new PaddedIconBuilder(icon).setTopBottomPaddings(verticalPadding / 2, verticalPadding / 2).setLeftRightPaddings(5, 4).build();
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createIcon"));
        }
        return icon3;
    }

    @Nullable
    public static Shortcut getKeyboardShortcut() {
        Object[] shortcuts = CommonShortcuts.getNewForDialogs().getShortcuts();
        return (Shortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "update"));
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "lambda$actionPerformed$2"));
            }
            List<VirtualFile> all = this.myService.detectAllBuildfiles(project);
            List filtered = ContainerUtil.filter(all, file -> {
                JsbtFileManager fileManager = this.myService.getFileManager(project);
                return !fileManager.containsBuildfile((VirtualFile)file);
            });
            UIUtil.invokeLaterIfNeeded(() -> {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "lambda$null$1"));
                }
                InputEvent inputEvent = e.getInputEvent();
                Component component = inputEvent.getComponent();
                if (component == null) {
                    return;
                }
                ListPopup popup = JsbtAddBuildfileAction.createPopup(project, this.myService, filtered);
                if (inputEvent instanceof MouseEvent) {
                    popup.show(new RelativePoint(component, ((MouseEvent)inputEvent).getPoint()));
                } else {
                    popup.showInCenterOf(component);
                }
            });
        });
    }

    @NotNull
    private static ListPopup createPopup(final @NotNull Project project, final @NotNull JsbtService service, @NotNull List<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createPopup"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createPopup"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createPopup"));
        }
        ArrayList values = ContainerUtil.newArrayList(files);
        values.add(null);
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(null, (List)values){

            @NotNull
            public String getTextFor(VirtualFile value) {
                if (value != null) {
                    String string = JsbtUtil.getRelativePath(project, value);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "getTextFor"));
                    }
                    return string;
                }
                String string = "Choose " + service.getBuildfileCommonName() + "...";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(VirtualFile file) {
                if (file != null) {
                    return file.getFileType().getIcon();
                }
                return null;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                JsbtFileManager fileManager = service.getFileManager(project);
                if (selectedValue != null) {
                    fileManager.addBuildfile(selectedValue);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (service == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "lambda$onChosen$1"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "lambda$onChosen$1"));
                        }
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                        fileChooserDescriptor.setTitle("Choose " + service.getBuildfileCommonName());
                        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null, files1 -> {
                            VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem((List)files1);
                            if (file != null) {
                                fileManager.addBuildfile(file);
                            }
                        });
                    });
                }
                return FINAL_CHOICE;
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction", "createPopup"));
        }
        return listPopup;
    }
}

