/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class JsbtRemoveBuildfileAction
extends AnAction
implements DumbAware {
    private final JsbtTaskTreeView myTaskTreeView;
    private final JsbtService myService;

    public JsbtRemoveBuildfileAction(@NotNull JsbtService service, @NotNull JsbtTaskTreeView taskTreeView) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRemoveBuildfileAction", "<init>"));
        }
        if (taskTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskTreeView", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRemoveBuildfileAction", "<init>"));
        }
        super("Remove " + service.getBuildfileCommonName());
        this.myTaskTreeView = taskTreeView;
        this.myService = service;
        this.getTemplatePresentation().setIcon(JavaScriptLanguageIcons.BuildTools.Minus);
        this.getTemplatePresentation().setHoveredIcon(JavaScriptLanguageIcons.BuildTools.Minus_hovered);
        this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0)));
    }

    public void update(AnActionEvent e) {
        List<DefaultMutableTreeNode> nodes;
        boolean enable;
        Project project = e.getProject();
        boolean bl = enable = project != null;
        if (enable && (nodes = this.myTaskTreeView.getSelectedNodes()).size() == 1) {
            enable = JsbtTree.getUserObject(nodes.get(0), JsbtFileStructure.class) != null;
        }
        Presentation presentation = e.getPresentation();
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setEnabledAndVisible(enable);
        } else {
            presentation.setEnabled(enable);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<DefaultMutableTreeNode> nodes = this.myTaskTreeView.getSelectedNodes();
        for (DefaultMutableTreeNode node : nodes) {
            JsbtFileStructure structure = JsbtTree.getUserObject(node, JsbtFileStructure.class);
            if (structure == null) continue;
            this.myService.getFileManager(project).removeBuildfile(structure.getBuildfile());
        }
    }
}

