/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtReloadTasksAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtServiceComboBoxAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtRunTaskAction
extends AnAction
implements DumbAware {
    private static final Key<JsbtService> LAST_SHOWN_SERVICE = Key.create((String)"LAST_SHOWN_SERVICE");
    private static final Key<WeakReference<JBPopup>> CURRENT_POPUP = Key.create((String)"CURRENT_POPUP");

    public JsbtRunTaskAction() {
        super("Run Gulp/Grunt/npm Task");
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "update"));
        }
        Project project = e.getProject();
        if (project == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean visible = false;
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (!fileManager.hasBuildfiles()) continue;
            visible = true;
            break;
        }
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null || project.isDefault()) {
            return;
        }
        JBPopup popup = JsbtRunTaskAction.getCurrentPopup(project);
        if (popup != null && popup.isVisible()) {
            return;
        }
        JsbtService lastShownService = JsbtRunTaskAction.getLastShownService(project);
        if (lastShownService == null || !lastShownService.getFileManager(project).hasBuildfiles()) {
            for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
                if (!service.getFileManager(project).hasBuildfiles()) continue;
                lastShownService = service;
                break;
            }
        }
        if (lastShownService != null) {
            JsbtRunTaskAction.setLastShownService(project, lastShownService);
        } else {
            lastShownService = (JsbtService)ArrayUtil.getFirstElement((Object[])JsbtService.EP_NAME.getExtensions());
        }
        if (lastShownService != null) {
            popup = JsbtRunTaskAction.showPopup(project, lastShownService);
            JsbtRunTaskAction.setCurrentPopup(project, popup);
        }
    }

    @Nullable
    private static JsbtService getLastShownService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "getLastShownService"));
        }
        return (JsbtService)LAST_SHOWN_SERVICE.get((UserDataHolder)project);
    }

    private static void setLastShownService(@NotNull Project project, @Nullable JsbtService service) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "setLastShownService"));
        }
        LAST_SHOWN_SERVICE.set((UserDataHolder)project, (Object)service);
    }

    @Nullable
    private static JBPopup getCurrentPopup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "getCurrentPopup"));
        }
        WeakReference popupRef = (WeakReference)CURRENT_POPUP.get((UserDataHolder)project);
        if (popupRef != null) {
            return (JBPopup)popupRef.get();
        }
        return null;
    }

    private static void setCurrentPopup(@NotNull Project project, @NotNull JBPopup popup) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "setCurrentPopup"));
        }
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "setCurrentPopup"));
        }
        CURRENT_POPUP.set((UserDataHolder)project, new WeakReference<JBPopup>(popup));
    }

    @NotNull
    private static JBPopup showPopup(final @NotNull Project project, @NotNull JsbtService service) {
        AnAction[] actions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "showPopup"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "showPopup"));
        }
        JsbtTaskTreeView treeView = service.createTaskTreeView(project, "tools.popup" + service.getName());
        treeView.init();
        Tree tree = treeView.getComponent();
        for (AnAction action : actions = new AnAction[]{new JsbtAddBuildfileAction(service, true), new JsbtRemoveBuildfileAction(service, treeView), new JsbtReloadTasksAction(treeView)}) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, (JComponent)tree);
        }
        final Ref popupRef = Ref.create();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        JsbtServiceComboBoxAction serviceComboBoxAction = new JsbtServiceComboBoxAction(service){

            @Override
            protected void onValueChanged(final @NotNull JsbtService service, @NotNull AnActionEvent e) {
                if (service == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction$1", "onValueChanged"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction$1", "onValueChanged"));
                }
                super.onValueChanged(service, e);
                JBPopup popup = (JBPopup)popupRef.get();
                if (popup != null && !popup.isDisposed()) {
                    popup.addListener((JBPopupListener)new JBPopupAdapter(){

                        public void onClosed(LightweightWindowEvent event) {
                            JsbtRunTaskAction.setLastShownService(project, service);
                            JBPopup popup = JsbtRunTaskAction.showPopup(project, service);
                            JsbtRunTaskAction.setCurrentPopup(project, popup);
                        }
                    });
                    popup.closeOk(null);
                }
            }
        };
        serviceComboBoxAction.setSmallVariant(true);
        actionGroup.add((AnAction)serviceComboBoxAction);
        actionGroup.addSeparator();
        actionGroup.addAll(actions);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        actionToolbar.setMinimumButtonSize(new Dimension(22, 22));
        JComponent toolbarComponent = actionToolbar.getComponent();
        JsbtRunTaskAction.setNotOpaqueRecursively(toolbarComponent);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree, (int)20, (int)30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Dimension treePrefSize = tree.getPreferredSize();
        scrollPane.getViewport().setPreferredSize(new Dimension(Math.max(JBUI.scale((int)250), Math.min(treePrefSize.width, JBUI.scale((int)400))), Math.max(JBUI.scale((int)250), Math.min(treePrefSize.height, JBUI.scale((int)500)))));
        ModalityState current = ModalityState.current();
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)tree).setMayBeParent(true).setRequestFocus(true).setFocusable(true).setFocusOwners(new Component[]{tree}).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setMovable(true).setResizable(true).setSettingButtons((Component)toolbarComponent).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setCancelCallback(() -> current.equals(ModalityState.current())).setDimensionServiceKey(project, "jetbrains.javascript.buildTools.run-task-popup", true).setMinSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)200))).setCancelButton(new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        JBPopup popup = builder.createPopup();
        popupRef.set((Object)popup);
        Disposer.register((Disposable)popup, (Disposable)treeView);
        treeView.addActionCallback(() -> popup.closeOk(null));
        popup.showCenteredInCurrentWindow(project);
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "showPopup"));
        }
        return jBPopup;
    }

    private static void setNotOpaqueRecursively(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/buildTools/base/actions/JsbtRunTaskAction", "setNotOpaqueRecursively"));
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
            for (Component c : ((JComponent)component).getComponents()) {
                JsbtRunTaskAction.setNotOpaqueRecursively(c);
            }
        }
    }
}

