/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntCoreTask
extends GruntTask {
    private final List<GruntTargetTask> myTargetTasks;

    public GruntCoreTask(@NotNull GruntfileStructure structure, @NotNull String name, @Nullable String info, @Nullable String filePath, boolean multi, @NotNull List<String> targetNames) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/grunt/GruntCoreTask", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/grunt/GruntCoreTask", "<init>"));
        }
        if (targetNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNames", "com/intellij/lang/javascript/buildTools/grunt/GruntCoreTask", "<init>"));
        }
        super(structure, name, info, filePath, multi);
        this.myTargetTasks = ImmutableList.copyOf((Collection)Lists.transform(targetNames, (Function)new Function<String, GruntTargetTask>(){

            public GruntTargetTask apply(String targetName) {
                return new GruntTargetTask(GruntCoreTask.this, targetName);
            }
        }));
    }

    @NotNull
    public List<GruntTargetTask> getTargetTasks() {
        List<GruntTargetTask> list = this.myTargetTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntCoreTask", "getTargetTasks"));
        }
        return list;
    }

    public GruntTargetTask findTarget(@NotNull String targetName) {
        if (targetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/intellij/lang/javascript/buildTools/grunt/GruntCoreTask", "findTarget"));
        }
        for (GruntTargetTask targetTask : this.myTargetTasks) {
            if (!targetName.equals(targetTask.getTargetName())) continue;
            return targetTask;
        }
        return null;
    }

    @Override
    public String toString() {
        List targetNames = Lists.transform(this.myTargetTasks, (Function)new Function<GruntTargetTask, String>(){

            public String apply(GruntTargetTask targetTask) {
                return targetTask.getTargetName();
            }
        });
        return this.getName() + ", targets: " + targetNames;
    }
}

