/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntUtil {
    public static final String DEFAULT_TASK_NAME = "default";

    public static void checkConfiguration(@NotNull Project project, @NotNull GruntNonSharedSettings nonSharedSettings, @NotNull GruntRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        if (nonSharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonSharedSettings", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "checkConfiguration"));
        }
        GruntUtil.validateFile(settings.getGruntfilePath(), "Unspecified Gruntfile", "Gruntfile not found", null);
        NodeJsLocalInterpreter.checkForRunConfiguration(settings.getInterpreterRef().resolve(project));
        GruntUtil.validateDir(nonSharedSettings.getGruntCliPackageDirPath(), "Unspecified grunt-cli package", "Grunt-cli package not found");
    }

    private static void validateFile(@NotNull String filePath, @NotNull String emptyPathMessage, @NotNull String fileNotFoundMessage, @Nullable String canNotExecuteFileMessage) throws RuntimeConfigurationError {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (emptyPathMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyPathMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (fileNotFoundMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNotFoundMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateFile"));
        }
        if (filePath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File file = new File(filePath);
        if (!file.isAbsolute() || !file.isFile()) {
            throw new RuntimeConfigurationError(fileNotFoundMessage);
        }
        if (canNotExecuteFileMessage != null && !file.canExecute()) {
            throw new RuntimeConfigurationError(canNotExecuteFileMessage);
        }
    }

    private static void validateDir(@NotNull String dirPath, @NotNull String emptyPathMessage, @NotNull String dirNotFoundMessage) throws RuntimeConfigurationError {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateDir"));
        }
        if (emptyPathMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyPathMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateDir"));
        }
        if (dirNotFoundMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNotFoundMessage", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "validateDir"));
        }
        if (dirPath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(emptyPathMessage);
        }
        File dir = new File(dirPath);
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            throw new RuntimeConfigurationError(dirNotFoundMessage);
        }
    }

    @NotNull
    public static String getBaseTaskName(@NotNull String fullTaskName) {
        if (fullTaskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullTaskName", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
        }
        int ind = fullTaskName.indexOf(58);
        if (ind == -1) {
            String string = fullTaskName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
            }
            return string;
        }
        String string = fullTaskName.substring(0, ind);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntUtil", "getBaseTaskName"));
        }
        return string;
    }
}

