/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParseException;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParser;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpJsonTaskListParser
implements GulpTaskListParser {
    public static final GulpJsonTaskListParser INSTANCE = new GulpJsonTaskListParser();
    private static final String NO_JSON_MESSAGE = "No JSON found";

    @Override
    @NotNull
    public List<Pair<String, List<String>>> parseTaskList(@NotNull String text) throws GulpTaskListParseException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser", "parseTaskList"));
        }
        char[] buffer = text.toCharArray();
        int endInd = CharArrayUtil.lastIndexOf((char[])buffer, (char)']', (int)0, (int)buffer.length);
        if (endInd < 0) {
            throw new GulpTaskListParseException(NO_JSON_MESSAGE);
        }
        GulpTaskListParseException firstException = null;
        int startInd = CharArrayUtil.indexOf((char[])buffer, (char)'[', (int)0, (int)endInd);
        while (startInd >= 0 && startInd < endInd) {
            List<Pair<String, List<String>>> list;
            try {
                list = GulpJsonTaskListParser.doParse((CharSequence)new CharArrayCharSequence(buffer, startInd, endInd + 1));
            }
            catch (GulpTaskListParseException e) {
                if (firstException == null) {
                    firstException = e;
                }
                startInd = CharArrayUtil.indexOf((char[])buffer, (char)'[', (int)(startInd + 1), (int)endInd);
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser", "parseTaskList"));
            }
            return list;
        }
        if (firstException != null) {
            throw firstException;
        }
        throw new GulpTaskListParseException(NO_JSON_MESSAGE);
    }

    private static List<Pair<String, List<String>>> doParse(@NotNull CharSequence jsonString) throws GulpTaskListParseException {
        if (jsonString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonString", "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser", "doParse"));
        }
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new CharSequenceReader(jsonString));
            List<Pair<String, List<String>>> list = GulpJsonTaskListParser.doParse(jsonReader);
            return list;
        }
        catch (IOException e) {
            throw new GulpTaskListParseException("Failed to parse JSON", e);
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    private static List<Pair<String, List<String>>> doParse(JsonReader reader) throws IOException, GulpTaskListParseException {
        JsonToken token = reader.peek();
        if (token != JsonToken.BEGIN_ARRAY) {
            throw new GulpTaskListParseException("Malformed JSON");
        }
        reader.beginArray();
        ArrayList result = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            token = reader.peek();
            if (token == JsonToken.BEGIN_OBJECT) {
                Pair<String, List<String>> pair = GulpJsonTaskListParser.readTask(reader);
                if (pair == null) continue;
                result.add(pair);
                continue;
            }
            reader.skipValue();
        }
        reader.endArray();
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser", "doParse"));
        }
        return arrayList;
    }

    @Nullable
    private static Pair<String, List<String>> readTask(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/lang/javascript/buildTools/gulp/GulpJsonTaskListParser", "readTask"));
        }
        JsonToken token = reader.peek();
        if (token != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String taskName = null;
        String type = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("label".equals(key)) {
                taskName = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if ("type".equals(key)) {
                type = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if ("task".equals(type) && taskName != null) {
            return Pair.create((Object)taskName, Collections.emptyList());
        }
        return null;
    }
}

