/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.google.common.base.Splitter;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListParser;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpPseudoGraphicTaskListParser
implements GulpTaskListParser {
    public static final GulpPseudoGraphicTaskListParser INSTANCE = new GulpPseudoGraphicTaskListParser();

    @Override
    @NotNull
    public List<Pair<String, List<String>>> parseTaskList(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "parseTaskList"));
        }
        ArrayList lines = ContainerUtil.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)text));
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        String topLevelName = null;
        ArrayList children = null;
        for (String line : lines) {
            if ((line = GulpPseudoGraphicTaskListParser.trimPrefix(line)).isEmpty()) continue;
            char firstChar = line.charAt(0);
            if (GulpPseudoGraphicTaskListParser.isPseudoTreeStartChar(firstChar)) {
                if (topLevelName != null) {
                    res.put(topLevelName, ObjectUtils.notNull(children, Collections.emptyList()));
                }
                topLevelName = GulpPseudoGraphicTaskListParser.getName(line, 0);
                children = null;
                continue;
            }
            if (line.length() >= 3 && (firstChar == '\u2502' || firstChar == ' ') && line.charAt(1) == ' ' && GulpPseudoGraphicTaskListParser.isPseudoTreeStartChar(line.charAt(2))) {
                String childName = GulpPseudoGraphicTaskListParser.getName(line, 3);
                if (children == null) {
                    children = ContainerUtil.newArrayList();
                }
                children.add(childName);
                continue;
            }
            if (topLevelName == null) continue;
            res.put(topLevelName, ObjectUtils.notNull(children, Collections.emptyList()));
            topLevelName = null;
            children = null;
        }
        if (topLevelName != null) {
            res.put(topLevelName, ObjectUtils.notNull(children, Collections.emptyList()));
        }
        ArrayList pairs = ContainerUtil.newArrayListWithCapacity((int)res.size());
        for (Map.Entry entry : res.entrySet()) {
            pairs.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        ArrayList arrayList = pairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "parseTaskList"));
        }
        return arrayList;
    }

    @Nullable
    private static String getName(@NotNull String line, int fromInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "getName"));
        }
        int startInd = line.indexOf(32, fromInd);
        if (startInd >= 0) {
            return line.substring(startInd + 1);
        }
        return null;
    }

    private static boolean isPseudoTreeStartChar(int ch) {
        return ch == 9500 || ch == 9492 || ch == 9484;
    }

    @NotNull
    private static String trimPrefix(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "trimPrefix"));
        }
        int endInd = line.indexOf(93);
        if (endInd >= 0 && line.charAt(0) == '[') {
            if (endInd + 1 < line.length() && line.charAt(endInd + 1) == ' ') {
                ++endInd;
            }
            String string = line.substring(endInd + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "trimPrefix"));
            }
            return string;
        }
        String string = line;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpPseudoGraphicTaskListParser", "trimPrefix"));
        }
        return string;
    }
}

