/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.util.ObjectUtils;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTask {
    private final GulpfileStructure myStructure;
    private final String myName;
    private final List<String> myDependencies;

    public GulpTask(@NotNull GulpfileStructure structure, @NotNull String name, @NotNull List<String> dependencies) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "<init>"));
        }
        this.myStructure = structure;
        this.myName = name;
        this.myDependencies = ImmutableList.copyOf(dependencies);
    }

    @NotNull
    public GulpfileStructure getStructure() {
        GulpfileStructure gulpfileStructure = this.myStructure;
        if (gulpfileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "getStructure"));
        }
        return gulpfileStructure;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "getName"));
        }
        return string;
    }

    @NotNull
    public List<String> getDependencies() {
        List<String> list = this.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpTask", "getDependencies"));
        }
        return list;
    }

    public int hashCode() {
        int result = this.myStructure.getGulpfile().hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GulpTask task = (GulpTask)o;
        return this.myStructure.getGulpfile().equals(task.myStructure.getGulpfile()) && this.myName.equals(task.myName);
    }

    @Nullable
    public static GulpTask getUserObject(@Nullable DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        return (GulpTask)ObjectUtils.tryCast((Object)node.getUserObject(), GulpTask.class);
    }
}

