/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpNonSharedSettingsManager {
    private static final String STORAGE_NODE_INTERPRETER_PATH = "js.buildTools.gulp.node_interpreter";
    private static final String STORAGE_GULP_PACKAGE_DIR_PATH = "js.buildTools.gulp.gulp_package_dir";
    private static final String GULP_PACKAGE_NAME = "gulp";
    private final Project myProject;
    private volatile GulpNonSharedSettings myNonSharedSettings;

    public GulpNonSharedSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "<init>"));
        }
        this.myNonSharedSettings = new GulpNonSharedSettings("");
        this.myProject = project;
    }

    @NotNull
    public GulpNonSharedSettings get(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGulpfile) {
        GulpNonSharedSettings settings = this.myNonSharedSettings;
        if (StringUtil.isNotEmpty((String)settings.getGulpPackageDirPath())) {
            GulpNonSharedSettings gulpNonSharedSettings = settings;
            if (gulpNonSharedSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "get"));
            }
            return gulpNonSharedSettings;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String gulpPackageDirPath = propertiesComponent.getValue(STORAGE_GULP_PACKAGE_DIR_PATH);
        if (StringUtil.isEmptyOrSpaces((String)gulpPackageDirPath)) {
            gulpPackageDirPath = StringUtil.notNullize((String)this.detectGulpPackageDirPath(interpreter, contextGulpfile));
        }
        settings = new GulpNonSharedSettings(gulpPackageDirPath);
        this.set(settings);
        GulpNonSharedSettings gulpNonSharedSettings = settings;
        if (gulpNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "get"));
        }
        return gulpNonSharedSettings;
    }

    @NotNull
    public String getOldNodeInterpreterPath() {
        String path = PropertiesComponent.getInstance((Project)this.myProject).getValue(STORAGE_NODE_INTERPRETER_PATH);
        path = StringUtil.notNullize((String)path);
        String string = FileUtil.toSystemIndependentName((String)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "getOldNodeInterpreterPath"));
        }
        return string;
    }

    @Nullable
    private String detectGulpPackageDirPath(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGulpfile) {
        ArrayList list = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = null;
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter != null && !localInterpreter.getInterpreterSystemDependentPath().isEmpty()) {
            nodeSettings = new NodeSettings(localInterpreter.getInterpreterSystemDependentPath());
        }
        VirtualFile requester = contextGulpfile != null ? contextGulpfile : this.myProject.getBaseDir();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)list, GULP_PACKAGE_NAME, requester, nodeSettings, true);
        for (CompletionModuleInfo moduleInfo : list) {
            VirtualFile file = moduleInfo.getVirtualFile();
            if (file == null) continue;
            return FileUtil.toSystemDependentName((String)file.getPath());
        }
        return null;
    }

    public void set(@NotNull GulpNonSharedSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "set"));
        }
        this.myNonSharedSettings = settings;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(STORAGE_GULP_PACKAGE_DIR_PATH, settings.getGulpPackageDirPath());
    }

    public void set(@NotNull String gulpPackageDirPath) {
        if (gulpPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDirPath", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "set"));
        }
        this.set(new GulpNonSharedSettings(gulpPackageDirPath));
    }

    @NotNull
    public List<String> detectAllGulpPackageDirs(@Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextGulpfile) {
        ArrayList modules = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = NodeSettings.create(NodeJsLocalInterpreter.tryCast(interpreter));
        VirtualFile requester = contextGulpfile != null ? contextGulpfile : this.myProject.getBaseDir();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)modules, GULP_PACKAGE_NAME, requester, nodeSettings, true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "detectAllGulpPackageDirs"));
        }
        return arrayList;
    }

    @NotNull
    public static GulpNonSharedSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "getInstance"));
        }
        GulpNonSharedSettingsManager gulpNonSharedSettingsManager = (GulpNonSharedSettingsManager)ServiceManager.getService((Project)project, GulpNonSharedSettingsManager.class);
        if (gulpNonSharedSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpNonSharedSettingsManager", "getInstance"));
        }
        return gulpNonSharedSettingsManager;
    }
}

