/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmScriptsUtil {
    private static final Logger LOG = Logger.getInstance(NpmScriptsUtil.class);

    private NpmScriptsUtil() {
    }

    @NotNull
    public static NpmScriptsStructure listTasks(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "listTasks"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "listTasks"));
        }
        Ref exRef = Ref.create();
        Ref structureRef = Ref.create();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "lambda$listTasks$0"));
            }
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "lambda$listTasks$0"));
            }
            try {
                structureRef.set((Object)NpmScriptsUtil.doBuildStructure(project, packageJson));
            }
            catch (JsbtTaskFetchException e) {
                exRef.set((Object)e);
            }
        });
        NpmScriptsStructure structure = (NpmScriptsStructure)structureRef.get();
        if (structure != null) {
            NpmScriptsStructure npmScriptsStructure = structure;
            if (npmScriptsStructure == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "listTasks"));
            }
            return npmScriptsStructure;
        }
        throw (JsbtTaskFetchException)exRef.get();
    }

    @NotNull
    private static NpmScriptsStructure doBuildStructure(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "doBuildStructure"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "doBuildStructure"));
        }
        if (!packageJson.isValid()) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        NpmScriptsStructure structure = new NpmScriptsStructure(packageJson);
        JsonProperty scriptsProperty = NpmScriptsUtil.findScriptsProperty(project, packageJson);
        if (scriptsProperty == null) {
            NpmScriptsStructure npmScriptsStructure = structure;
            if (npmScriptsStructure == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "doBuildStructure"));
            }
            return npmScriptsStructure;
        }
        JsonObject map = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class);
        if (map != null) {
            ArrayList scripts = ContainerUtil.newArrayList();
            for (JsonProperty property : map.getPropertyList()) {
                scripts.add(new NpmScript(structure, property.getName()));
            }
            structure.setScripts(scripts);
        }
        NpmScriptsStructure npmScriptsStructure = structure;
        if (npmScriptsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "doBuildStructure"));
        }
        return npmScriptsStructure;
    }

    @NotNull
    private static JsbtTaskFetchException invalidFile(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "invalidFile"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "invalidFile"));
        }
        return jsbtTaskFetchException;
    }

    @Nullable
    private static JsonProperty findScriptsProperty(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "findScriptsProperty"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "findScriptsProperty"));
        }
        PsiManagerEx psiManager = PsiManagerEx.getInstanceEx((Project)project);
        PsiFile psiFile = psiManager.getFileManager().findFile(packageJson);
        if (psiFile == null) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
        if (jsonFile == null) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class);
        if (topObject == null) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        return topObject.findProperty("scripts");
    }

    @Nullable
    public static JsonProperty findScriptProperty(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull String scriptName) {
        JsonProperty scriptsProperty;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "findScriptProperty"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "findScriptProperty"));
        }
        if (scriptName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptName", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil", "findScriptProperty"));
        }
        if (project.isDisposed() || !packageJson.isValid()) {
            return null;
        }
        try {
            scriptsProperty = NpmScriptsUtil.findScriptsProperty(project, packageJson);
        }
        catch (JsbtTaskFetchException e) {
            LOG.info("Cannot fetch 'scripts' from " + packageJson.getPath());
            return null;
        }
        if (scriptsProperty == null) {
            return null;
        }
        JsonObject scriptsObj = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class);
        if (scriptsObj == null) {
            return null;
        }
        return scriptsObj.findProperty(scriptName);
    }
}

