/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmTaskTreeView
extends JsbtTaskTreeView {
    private static final String NO_SCRIPTS_FOUND = "No scripts found";

    public NpmTaskTreeView(@NotNull NpmScriptsService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "<init>"));
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "addBuildfileChildren"));
        }
        if (_structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_structure", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "addBuildfileChildren"));
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)_structure;
        for (NpmScript script : structure.getScripts()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(script, false);
            buildfileTreeNode.add(node);
        }
        if (structure.getScripts().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(NO_SCRIPTS_FOUND, false));
        }
    }

    @Override
    protected int compareNodes(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2, @NotNull JsbtSortingMode sortingMode) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "compareNodes"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "compareNodes"));
        }
        if (sortingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortingMode", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "compareNodes"));
        }
        NpmScript script1 = NpmScript.getUserObject(node1);
        NpmScript script2 = NpmScript.getUserObject(node2);
        if (script1 == null || script2 == null) {
            if (script1 == null && script2 == null) {
                return 0;
            }
            return script1 == null ? 1 : -1;
        }
        if (sortingMode == JsbtSortingMode.NAME) {
            return script1.getName().compareTo(script2.getName());
        }
        return NpmTaskTreeView.getPosition(script1) - NpmTaskTreeView.getPosition(script2);
    }

    private static int getPosition(@NotNull NpmScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "getPosition"));
        }
        return script.getStructure().getScripts().indexOf(script);
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode packageJsonTreeNode) {
        if (packageJsonTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonTreeNode", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "hasTaskNodes"));
        }
        int childCount = packageJsonTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)packageJsonTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            NpmScript task = NpmScript.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "customizeCell"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "customizeCell"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "customizeCell"));
        }
        NpmScriptsStructure structure = NpmScriptsStructure.getUserObject(node);
        if (structure != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.Npm.Npm_16);
            renderer.setIconOnTheRight(false);
            renderer.append(JsbtUtil.getRelativePath(project, structure.getBuildfile()));
            return;
        }
        if (NO_SCRIPTS_FOUND.equals(node.getUserObject())) {
            renderer.append(NO_SCRIPTS_FOUND, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        NpmScript script = NpmScript.getUserObject(node);
        if (script != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.BuildToolTask);
            renderer.append(script.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "getPersistentId"));
        }
        NpmScriptsStructure structure = NpmScriptsStructure.getUserObject(node);
        if (structure != null) {
            return structure.getBuildfile().getPath();
        }
        NpmScript script = NpmScript.getUserObject(node);
        return script != null ? script.getName() : null;
    }

    @Override
    @Nullable
    protected String stringifyForSpeedSearch(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "stringifyForSpeedSearch"));
        }
        NpmScript script = NpmScript.getUserObject(node);
        return script != null ? script.getName() : null;
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        NpmScriptsStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            NpmScript script = NpmScript.getUserObject(node);
            if (script == null) {
                return null;
            }
            NpmScriptsStructure structure = script.getStructure();
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            taskNames.add(script.getName());
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected OpenFileDescriptor createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        Location location;
        VirtualFile virtualPackageJson;
        JsonProperty property;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "createJumpToSourceDescriptor"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/npm/NpmTaskTreeView", "createJumpToSourceDescriptor"));
        }
        NpmScript script = NpmScript.getUserObject(node);
        if (script != null && (property = NpmScriptsUtil.findScriptProperty(project, virtualPackageJson = script.getStructure().getBuildfile(), script.getName())) != null && (location = PsiLocation.fromPsiElement((PsiElement)property)) != null) {
            return location.getOpenFileDescriptor();
        }
        return null;
    }
}

