/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum NpmCommand {
    ACCESS,
    ADD_USER("adduser"),
    BIN,
    BUGS,
    BUILD,
    CACHE,
    COMPLETION,
    CONFIG,
    DEDUPE,
    DEPRECATE,
    DIST_TAG("dist-tag"),
    DOCS,
    EDIT,
    EXPLORE,
    HELP,
    HELP_SEARCH("help-search"),
    INIT,
    INSTALL,
    LINK,
    LOGOUT,
    LS,
    NPM,
    OUTDATED,
    OWNER,
    PACK,
    PING,
    PREFIX,
    PRUNE,
    PUBLISH,
    REBUILD,
    REPO,
    RESTART,
    ROOT,
    RUN_SCRIPT("run"),
    SEARCH,
    SHRINKWRAP,
    STAR,
    STARS,
    START,
    STOP,
    TAG,
    TEAM,
    TEST,
    UNINSTALL("uninstall", "remove"),
    UNPUBLISH,
    UPDATE("update", "upgrade"),
    VERSION,
    VIEW,
    WHOAMI;

    private final String myCliOption;
    private final String myYarnCliOption;

    private NpmCommand() {
        this.myYarnCliOption = this.myCliOption = this.name().toLowerCase(Locale.ENGLISH);
    }

    private NpmCommand(String cliOption) {
        if (cliOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cliOption", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "<init>"));
        }
        this(cliOption, cliOption);
    }

    private NpmCommand(String cliOption, String yarnCliOption) {
        if (cliOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cliOption", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "<init>"));
        }
        this.myCliOption = cliOption;
        this.myYarnCliOption = StringUtil.notNullize((String)yarnCliOption, (String)cliOption);
    }

    @NotNull
    public String getCliOption() {
        String string = this.myCliOption;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "getCliOption"));
        }
        return string;
    }

    @NotNull
    public String getCliOption(boolean yarn) {
        String string = yarn ? this.myYarnCliOption : this.myCliOption;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "getCliOption"));
        }
        return string;
    }

    @Nullable
    public static NpmCommand find(@Nullable String cliOption) {
        for (NpmCommand command : NpmCommand.values()) {
            if (!command.getCliOption().equals(cliOption)) continue;
            return command;
        }
        return null;
    }
}

