/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class NpmRunConfigurationEditor
extends SettingsEditor<NpmRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(NpmRunConfigurationEditor.class);
    private final TextFieldWithHistoryWithBrowseButton myPackageJsonField;
    private final ComboBox myCommandField;
    private final TextFieldWithHistory myScriptsField;
    private final RawCommandLineEditor myArgumentsEditor;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public NpmRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "<init>"));
        }
        this.myPackageJsonField = NpmRunConfigurationEditor.createPackageJsonField(project);
        this.myCommandField = NpmRunConfigurationEditor.createCommandField();
        this.myScriptsField = NpmRunConfigurationEditor.createScriptsField(project, this.myPackageJsonField, this.myCommandField);
        this.myArgumentsEditor = NpmRunConfigurationEditor.createArgumentsEditor();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = NpmRunConfigurationEditor.createNodeOptionsEditor();
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"npm.rc.packageJson.label", (Object[])new Object[0]), (JComponent)this.myPackageJsonField).addLabeledComponent(JSBundle.message((String)"npm.rc.command.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myCommandField)).addLabeledComponent(JSBundle.message((String)"npm.rc.scripts.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myScriptsField)).addLabeledComponent(JSBundle.message((String)"npm.rc.scriptsArguments.label", (Object[])new Object[0]), (JComponent)this.myArgumentsEditor).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField), 8).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"npm.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createPackageJsonField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createPackageJsonField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"npm.rc.packageJson.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "lambda$createPackageJsonField$1"));
            }
            List<VirtualFile> packageJsonFiles = NpmScriptsService.getInstance().detectAllBuildfiles(project);
            List packageJsonPaths = packageJsonFiles.stream().map(packageJson -> FileUtil.toSystemDependentName((String)packageJson.getPath())).collect(Collectors.toList());
            Collections.sort(packageJsonPaths);
            return packageJsonPaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createPackageJsonField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static ComboBox<NpmCommand> createCommandField() {
        ComboBox comboBox = new ComboBox((Object[])NpmCommand.values());
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<NpmCommand>(){

            public void customize(JList list, NpmCommand value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getCliOption());
                }
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createCommandField"));
        }
        return comboBox2;
    }

    @NotNull
    private static TextFieldWithHistory createScriptsField(final @NotNull Project project, final @NotNull TextFieldWithHistoryWithBrowseButton packageJsonField, final @NotNull ComboBox commandField) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createScriptsField"));
        }
        if (packageJsonField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonField", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createScriptsField"));
        }
        if (commandField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandField", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createScriptsField"));
        }
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        commandField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                field.setEnabled(commandField.getSelectedItem() == NpmCommand.RUN_SCRIPT);
            }
        });
        final Ref lastPackageJsonRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(packageJsonField.getText());
                if (packageJson == null || !packageJson.isValid() || packageJson.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastPackageJsonRef.set(null);
                    return;
                }
                if (packageJson.equals(lastPackageJsonRef.get())) {
                    return;
                }
                lastPackageJsonRef.set((Object)packageJson);
                try {
                    NpmScriptsStructure structure = NpmScriptsService.getInstance().fetchBuildfileStructure(project, packageJson);
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                }
                catch (JsbtTaskFetchException ex) {
                    LOG.warn((Throwable)ex);
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createScriptsField"));
        }
        return textFieldWithHistory;
    }

    @NotNull
    public static RawCommandLineEditor createArgumentsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Arguments");
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createArgumentsEditor"));
        }
        return rawCommandLineEditor;
    }

    @NotNull
    public static RawCommandLineEditor createNodeOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Node.js Options");
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createNodeOptionsEditor"));
        }
        return rawCommandLineEditor;
    }

    protected void resetEditorFrom(@NotNull NpmRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "resetEditorFrom"));
        }
        this.resetEditorFrom(configuration.getRunSettings());
    }

    public void resetEditorFrom(NpmRunSettings runSettings) {
        this.myPackageJsonField.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)runSettings.getPackageJsonSystemIndependentPath()));
        this.myCommandField.setSelectedItem((Object)runSettings.getCommand());
        this.myScriptsField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getScriptNames()));
        this.myArgumentsEditor.setText(runSettings.getArguments());
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        DialogWrapper wrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (wrapper instanceof SingleConfigurableEditor || wrapper instanceof NpmBeforeRunTaskDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            SwingHelper.resizeDialogToFitTextFor((JComponent[])new JComponent[]{this.myPackageJsonField});
        }
    }

    protected void applyEditorTo(@NotNull NpmRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "applyEditorTo"));
        }
        configuration.setRunSettings(this.getCurrentSettings());
    }

    @NotNull
    public NpmRunSettings getCurrentSettings() {
        NpmRunSettings.Builder builder = NpmRunSettings.builder();
        builder.setPackageJsonPath(this.myPackageJsonField.getText());
        NpmCommand command = (NpmCommand)((Object)this.myCommandField.getSelectedItem());
        if (command == null) {
            LOG.error("null command");
            command = NpmCommand.INSTALL;
        }
        builder.setCommand(command);
        builder.setScriptNames(ParametersListUtil.parse((String)StringUtil.notNullize((String)this.myScriptsField.getText()), (boolean)false));
        builder.setArguments(this.myArgumentsEditor.getText());
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        NpmRunSettings npmRunSettings = builder.build();
        if (npmRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "getCurrentSettings"));
        }
        return npmRunSettings;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

