/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSDialectUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "JavaScript versions";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/dialects/JSDialectUsagesCollector", "getProjectUsages"));
        }
        JSLanguageLevel state = JSRootConfiguration.getInstance(project).getStoredLanguageLevel();
        String jsLangLevel = state == null ? "DEFAULT" : state.toString();
        HashSet descriptors = new HashSet();
        descriptors.add(new UsageDescriptor(jsLangLevel, 1));
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSDialectUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

