/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.validation.TypeScriptFunctionSignatureChecker;
import com.intellij.lang.typescript.validation.TypeScriptTypeChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatorCheckerProvider {
    private static final TypeScriptAnnotatorCheckerProvider DEFAULT = new TypeScriptAnnotatorCheckerProvider();
    public static final ExtensionPointName<TypeScriptAnnotatorCheckerProvider> EP = ExtensionPointName.create((String)"JavaScript.TypeScriptAnnotatorCheckerProvider");
    public static final HighlightSeverity TS_INFORMATION = new HighlightSeverity("TS Annotation info", HighlightSeverity.INFORMATION.myVal);

    @NotNull
    public static TypeScriptAnnotatorCheckerProvider getCheckerProvider(PsiElement context) {
        Project project = context.getProject();
        if (!Extensions.getArea((AreaInstance)project).hasExtensionPoint(EP.getName())) {
            TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = DEFAULT;
            if (typeScriptAnnotatorCheckerProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getCheckerProvider"));
            }
            return typeScriptAnnotatorCheckerProvider;
        }
        for (TypeScriptAnnotatorCheckerProvider provider : (TypeScriptAnnotatorCheckerProvider[])EP.getExtensions((AreaInstance)project)) {
            if (!provider.isAvailable(context)) continue;
            TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = provider;
            if (typeScriptAnnotatorCheckerProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getCheckerProvider"));
            }
            return typeScriptAnnotatorCheckerProvider;
        }
        TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = DEFAULT;
        if (typeScriptAnnotatorCheckerProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getCheckerProvider"));
        }
        return typeScriptAnnotatorCheckerProvider;
    }

    @NotNull
    public JSAnnotatorProblemReporter getProblemReporter(final @NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getProblemReporter"));
        }
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = new JSAnnotatorProblemReporter(holder){

            @Override
            protected Annotation registerProblem(@Nullable PsiElement nameIdentifier, @Nullable TextRange range, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
                if (intentionActions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider$1", "registerProblem"));
                }
                if (TypeScriptAnnotatorCheckerProvider.this.skipErrors() && nameIdentifier != null) {
                    if (range == null) {
                        range = nameIdentifier.getTextRange();
                    }
                    HighlightDisplayKey displayKey = inspectionId != null ? HighlightDisplayKey.find((String)inspectionId) : null;
                    Annotation annotation = holder.createAnnotation(TypeScriptAnnotatorCheckerProvider.getSeverity(), range, null);
                    JSAnnotatorProblemReporter.registerIntentionAndFixes(nameIdentifier, fixes, intentionActions, annotation, nameIdentifier.getContainingFile(), displayKey);
                    return annotation;
                }
                if (TypeScriptAnnotatorCheckerProvider.this.isWarningOnly(nameIdentifier) && type != ProblemHighlightType.WEAK_WARNING) {
                    type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                return super.registerProblem(nameIdentifier, range, message, type, inspectionId, fixes, intentionActions);
            }
        };
        if (jSAnnotatorProblemReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getProblemReporter"));
        }
        return jSAnnotatorProblemReporter;
    }

    @NotNull
    private static HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = ApplicationManager.getApplication().isUnitTestMode() ? HighlightSeverity.INFORMATION : TS_INFORMATION;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getSeverity"));
        }
        return highlightSeverity;
    }

    protected boolean isWarningOnly(@Nullable PsiElement currentElement) {
        if (currentElement == null) {
            return false;
        }
        PsiFile file = currentElement.getContainingFile();
        if (file instanceof JSFile) {
            return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences((JSFile)file);
        }
        return false;
    }

    protected boolean skipErrors() {
        return false;
    }

    @NotNull
    public JSTypeChecker<Annotation> getTypeChecker(@NotNull JSProblemReporter<Annotation> reporter) {
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getTypeChecker"));
        }
        TypeScriptTypeChecker typeScriptTypeChecker = new TypeScriptTypeChecker(reporter);
        if (typeScriptTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getTypeChecker"));
        }
        return typeScriptTypeChecker;
    }

    @NotNull
    public TypeScriptFunctionSignatureChecker getSignatureChecker(@NotNull JSTypeChecker<Annotation> typeChecker, @NotNull JSProblemReporter<Annotation> reporter) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        TypeScriptFunctionSignatureChecker typeScriptFunctionSignatureChecker = new TypeScriptFunctionSignatureChecker(typeChecker, reporter);
        if (typeScriptFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        return typeScriptFunctionSignatureChecker;
    }

    protected boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider", "isAvailable"));
        }
        return true;
    }
}

