/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSSuperExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String TYPESCRIPT_DECLARATIONS_JSX_FILE_EXTENSION = ".d.tsx";
    public static final String[] TYPESCRIPT_EXTENSIONS = new String[]{".d.ts", ".ts", ".tsx"};
    public static final String COMPILER_DIRECTORY_NAME = "jsLanguageServicesImpl";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = element -> element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
    public static final String TYPINGS = "typings";
    public static final String TYPES = "types";

    @NotNull
    public static ResolveResult resolveConstructorMatchingArguments(@NotNull JSClass clazz, @NotNull JSExpression methodExpression) {
        JSFunction[] constructors;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor("constructor", methodExpression.getContainingFile(), methodExpression, false);
        THashSet visitedClasses = new THashSet();
        ArrayDeque<JSClass> classQueue = new ArrayDeque<JSClass>();
        PsiElement parent = methodExpression.getParent();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            PsiElement element;
            ResolveResult[] results;
            JSClass currentClass = (JSClass)classQueue.poll();
            if (!visitedClasses.add(currentClass.getQualifiedName())) continue;
            JSResolveUtil.processDeclarationsInScope((JSElement)currentClass, processor, ResolveState.initial(), null, (PsiElement)methodExpression);
            for (ResolveResult resolveResult : results = ((SinkResolveProcessor)processor).getResultsAsResolveResults()) {
                if (!resolveResult.isValidResult() || !(resolveResult.getElement() instanceof JSFunction)) continue;
                PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult(resolveResult.getElement(), true);
                if (psiElementResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return psiElementResolveResult;
            }
            if (results.length >= 1) {
                ResolveResult resolveResult = results[0];
                if (resolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return resolveResult;
            }
            if (currentClass instanceof TypeScriptClass && parent instanceof JSNewExpression && (element = JSSuperExpressionImpl.matchTypeScriptSuperConstructor((JSCallExpression)((JSNewExpression)parent), (TypeScriptClass)currentClass)) != null) {
                PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult(element, true);
                if (psiElementResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return psiElementResolveResult;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        if (parent instanceof JSNewExpression && ((JSNewExpression)parent).getArguments().length == 0) {
            PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult((PsiElement)clazz, true);
            if (psiElementResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
            }
            return psiElementResolveResult;
        }
        JSClass resolveResult = clazz;
        if (clazz instanceof TypeScriptClass && (constructors = ((TypeScriptClass)clazz).getConstructors()).length == 1) {
            resolveResult = constructors[0];
        }
        PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult((PsiElement)resolveResult, false);
        if (psiElementResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        return psiElementResolveResult;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> resolveConstructorFunctions(@NotNull TypeScriptClass clazz, @NotNull PsiElement methodExpression) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
        }
        THashSet visitedClasses = new THashSet();
        ArrayDeque<TypeScriptClass> classQueue = new ArrayDeque<TypeScriptClass>();
        PsiElement parent = methodExpression.getParent();
        if (!(methodExpression instanceof JSNewExpression) && !(parent instanceof JSNewExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
            }
            return list;
        }
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            TypeScriptClass currentClass;
            JSClass rawClass = (JSClass)classQueue.poll();
            if (!(rawClass instanceof TypeScriptClass) || !visitedClasses.add((currentClass = (TypeScriptClass)rawClass).getQualifiedName())) continue;
            JSFunction[] constructors = currentClass.getConstructors();
            if (constructors.length > 0) {
                Collection collection = Arrays.stream(constructors).map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
                }
                return collection;
            }
            Collection indirectConstructors = currentClass.getIndirectSuperConstructors();
            if (!indirectConstructors.isEmpty()) {
                Collection collection = indirectConstructors.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
                }
                return collection;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorFunctions"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile findFileByReferencePath(@NotNull PsiFile file, @NotNull String referencePath, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        ConcurrentMap refPathToVirtualFile = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "lambda$findFileByReferencePath$1"));
            }
            ConcurrentMap result = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file, JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER});
        });
        Object value = refPathToVirtualFile.get(referencePath);
        if (value == null) {
            VirtualFile result = TypeScriptUtil.calcFileByReferencePath(file, referencePath);
            refPathToVirtualFile.put(referencePath, result == null ? ObjectUtils.NULL : result);
            return result;
        }
        return TypeScriptUtil.getValue(value);
    }

    @Nullable
    private static VirtualFile getValue(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getValue"));
        }
        if (object instanceof VirtualFile) {
            return (VirtualFile)object;
        }
        return null;
    }

    @Nullable
    private static VirtualFile calcFileByReferencePath(@NotNull PsiFile file, @NotNull String referencePath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "calcFileByReferencePath"));
        }
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "calcFileByReferencePath"));
        }
        VirtualFile result = null;
        referencePath = StringUtil.replaceChar((String)referencePath, (char)'\\', (char)'/');
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile.getParent();
        if (referencePath.startsWith(".")) {
            if (dir != null) {
                result = TypeScriptUtil.getFileByRelativePath(referencePath, dir);
            }
        } else {
            Project project = file.getProject();
            VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile, true);
            VirtualFile imported = TypeScriptUtil.findForContentRoot(referencePath, contentRootForFile, dir);
            if (imported == null) {
                for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                    if (!contentRoot.equals(contentRootForFile) && (imported = TypeScriptUtil.findForContentRoot(referencePath, contentRoot, contentRoot)) != null) break;
                }
            }
            result = imported;
        }
        return result;
    }

    @Nullable
    private static VirtualFile findForContentRoot(@NotNull String referencePath, VirtualFile contentRoot, VirtualFile startFrom) {
        VirtualFile contentRootParent;
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findForContentRoot"));
        }
        VirtualFile imported = null;
        VirtualFile virtualFile = contentRootParent = contentRoot != null ? contentRoot.getParent() : null;
        while (imported == null && startFrom != null && startFrom.isInLocalFileSystem()) {
            imported = TypeScriptUtil.getFileByRelativePath(referencePath, startFrom);
            if (contentRootParent != null && startFrom.equals(contentRootParent)) break;
            startFrom = startFrom.getParent();
        }
        return imported;
    }

    private static VirtualFile getFileByRelativePath(@NotNull String referencePath, VirtualFile currentParent) {
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getFileByRelativePath"));
        }
        VirtualFile imported = currentParent.findFileByRelativePath(referencePath);
        if (imported == null || imported.isDirectory()) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_DECLARATIONS_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_JSX_FILE_EXTENSION);
        }
        return imported;
    }

    @NotNull
    public static ResolveResult[] findExternalModule(@NotNull PsiFile refFile, @NotNull String moduleReference, @NotNull Project project) {
        Collection<TypeScriptModule> patternExternalModules;
        List patterns;
        Pair pair;
        if (refFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refFile", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String unquotedModuleName = StringUtil.unquoteString((String)moduleReference);
        String quotedModuleName = TypeScriptUtil.unifyModuleName(StringUtil.wrapWithDoubleQuote((String)unquotedModuleName));
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)refFile);
        Collection<JSQualifiedNamedElement> modules = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(quotedModuleName, scope);
        if (!modules.isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            for (JSNamedElement jSNamedElement : modules) {
                if (!(jSNamedElement instanceof TypeScriptModule) || ((TypeScriptModule)jSNamedElement).isAugmentation()) continue;
                result.add(new JSResolveResult((PsiElement)jSNamedElement));
            }
            if (!ContainerUtil.isEmpty((Collection)result)) {
                ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
                }
                return resolveResultArray;
            }
        }
        if ((pair = JSPathMappingsUtil.findMaxElementByPaths(unquotedModuleName, patterns = (patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(project, (PsiElement)refFile)).stream().map(module -> JSPathMappingsUtil.createPatternForString(StringUtil.unquoteString((String)module.getName()))).collect(Collectors.toList()))) != null && pair.getFirst() != null) {
            ArrayList resultPatternModules = ContainerUtil.newArrayList();
            String pattern = StringUtil.wrapWithDoubleQuote((String)((JSModulePattern)pair.getFirst()).getPattern());
            for (TypeScriptModule module3 : patternExternalModules) {
                if (!pattern.equals(module3.getName())) continue;
                resultPatternModules.add(new JSResolveResult((PsiElement)module3));
            }
            ResolveResult[] resolveResultArray = resultPatternModules.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getAllRegularExternalModules"));
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"reg", (Project)project, (GlobalSearchScope)JSResolveUtil.getResolveScope(owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllPatternExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getAllPatternExternalModules"));
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"pat", (Project)project, (GlobalSearchScope)JSResolveUtil.getResolveScope(owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllAugmentationModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getAllAugmentationModules"));
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"aug", (Project)project, (GlobalSearchScope)JSResolveUtil.getResolveScope(owner), TypeScriptModule.class);
    }

    @Contract(value="!null -> !null")
    public static String unifyModuleName(@Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        return StringUtil.replaceChar((String)qualifiedName, (char)'\'', (char)'\"');
    }

    public static JSQualifiedName unifyModuleName(JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        boolean containsSingleQuote = false;
        for (JSQualifiedName component = qualifiedName; component != null; component = component.getParent()) {
            if (!StringUtil.containsChar((String)component.getName(), (char)'\'')) continue;
            containsSingleQuote = true;
            break;
        }
        if (containsSingleQuote) {
            List components = qualifiedName.toComponents();
            for (int i = 0; i < components.size(); ++i) {
                components.set(i, StringUtil.replaceChar((String)((String)components.get(i)), (char)'\'', (char)'\"'));
            }
        }
        return qualifiedName;
    }

    @NotNull
    public static Collection<JSClass<?>> getNonStrictParents(@NotNull JSClass<?> clazz, boolean includeInterfaces) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNonStrictParents"));
        }
        final ArrayList result = new ArrayList();
        JSClassUtils.processClassesInHierarchy(clazz, includeInterfaces, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1", "process"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1", "process"));
                }
                result.add(aClass);
                return true;
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNonStrictParents"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<JSClass> resolveAliasesToClass(@NotNull JSClass[] classes, boolean includeInterfaces) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
        }
        if (classes.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
            }
            return list;
        }
        if (!includeInterfaces) {
            List list = ContainerUtil.newSmartList((Object[])classes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (JSClass currentClass : classes) {
            if (currentClass instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)currentClass, result, null);
                continue;
            }
            result.add(currentClass);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
        }
        return list;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveNameToClassesOverAliases"));
        }
        if (resultCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultCollection", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveNameToClassesOverAliases"));
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(name, context);
        for (PsiElement psiElement : result.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    public static void resolveAliasToClass(@NotNull TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, @Nullable Collection<JSClass> visitedAliases) {
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasToClass"));
        }
        if (resultCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultCollection", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasToClass"));
        }
        JSTypeDeclaration declaration = alias.getTypeDeclaration();
        if (declaration instanceof TypeScriptSingleType) {
            if (visitedAliases == null) {
                visitedAliases = ContainerUtil.newHashSet();
            }
            if (!visitedAliases.add(alias)) {
                return;
            }
            TypeScriptSingleType singleType = (TypeScriptSingleType)declaration;
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), (PsiElement)alias, resultCollection, visitedAliases);
        }
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNamedMembers"));
        }
        Iterable members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement member : members) {
            if (!(member instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)member);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNamedMembers"));
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInParentClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript((PsiElement)surroundClass)) {
            Ref ref = new Ref((Object)typeInParentClass);
            TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, ContainerUtil.emptyList(), parentClass, (Ref<JSType>)ref);
            JSType jSType = ref.get() == null ? typeInParentClass : (JSType)ref.get();
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function, @Nullable JSClass surroundClass) {
        TypeScriptTypeParameterList list;
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (classOfContext != null && (list = function.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list.getTypeParameters(), parameter -> {
                if (parameter.getTypeConstraint() != null) {
                    JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameter.getTypeConstraint());
                    if (JSTypeUtils.hasGenericParameter(type)) {
                        type = TypeScriptUtil.applyGenericsToType(type, surroundClass, classOfContext);
                    }
                    return parameter.getName() + " extends " + type.getTypeText(JSType.TypeTextFormat.CODE);
                }
                return parameter.getName();
            }, (String)", ");
            String string = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "buildParameterTypeListStringWithApplyingGenerics"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "buildParameterTypeListStringWithApplyingGenerics"));
        }
        return "";
    }

    @NotNull
    public static Map<JSNamedElement, JSClass> getUnimplementedMembers(JSClass jsClass, final boolean includeOptional) {
        final ArrayList implementedInterfaces = new ArrayList();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        JSClassUtils.processClassesInHierarchy(jsClass, true, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2", "process"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2", "process"));
                }
                JSAttributeList attributeList = aClass.getAttributeList();
                if (includeOptional || fromImplements || attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    implementedInterfaces.add(aClass);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }
        });
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass);
        LinkedHashMap<Pair, JSClass> membersToImplement = new LinkedHashMap<Pair, JSClass>();
        for (JSClass implementedInterface : implementedInterfaces) {
            ArrayList<Pair> implementedMembers = new ArrayList<Pair>();
            if (implementedInterface instanceof TypeScriptInterface) {
                TypeScriptObjectType body = ((TypeScriptInterface)implementedInterface).getBody();
                if (body == null) continue;
                for (TypeScriptTypeMember typeMember : body.getTypeMembers()) {
                    JSRecordType.TypeMember interfaceTypeMember;
                    if (typeMember instanceof TypeScriptIndexSignature || (interfaceTypeMember = TypeScriptTypeMemberParser.buildTypeMember(typeMember)) == null) continue;
                    implementedMembers.add(Pair.create((Object)interfaceTypeMember, (Object)((JSNamedElement)typeMember)));
                }
            } else if (implementedInterface instanceof TypeScriptClass) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)implementedInterface, true);
                for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                    JSRecordType.TypeMember member;
                    if (classMember instanceof TypeScriptIndexSignature || (member = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(implementedInterface, (JSElement)classMember, false, typeSource, (JSTypeSubstitutor)typeSubstitutors.get(implementedInterface))) == null) continue;
                    implementedMembers.add(Pair.create((Object)member, (Object)classMember));
                }
            }
            JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, false);
            classType = (JSRecordType)classType.transformTypeHierarchy(type -> TypeScriptUtil.replaceThisType(type, jsClass, source));
            JSRecordTypeImpl objectType = null;
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            for (Pair implementedMember : implementedMembers) {
                boolean memberIsAlreadyAdded = false;
                for (Pair member : membersToImplement.keySet()) {
                    if (member == null || !((JSRecordType.TypeMember)member.first).isEquivalentTo((JSRecordType.TypeMember)implementedMember.first, true)) continue;
                    memberIsAlreadyAdded = true;
                    break;
                }
                if (memberIsAlreadyAdded) continue;
                typeMembers.clear();
                typeMembers.add(includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember((JSRecordType.TypeMember)implementedMember.first) : (JSRecordType.TypeMember)implementedMember.first);
                JSRecordTypeImpl type2 = new JSRecordTypeImpl(source, typeMembers);
                type2 = type2.transformTypeHierarchy(type1 -> TypeScriptUtil.replaceThisType(type1, jsClass, source));
                ProcessingContext context = new ProcessingContext();
                context.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
                if (type2.isDirectlyAssignableType((JSType)classType, context)) continue;
                if (objectType == null) {
                    List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                    for (JSClass objectClass : objectClasses) {
                        JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false);
                        if (objectType == null) {
                            objectType = currentObjectType;
                            continue;
                        }
                        List objectTypeMembers = ContainerUtil.concat((List)objectType.getTypeMembers(), (List)currentObjectType.getTypeMembers());
                        objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                    }
                    if (objectType == null) {
                        objectType = new JSRecordTypeImpl(source, Collections.emptyList());
                    }
                }
                if (type2.isDirectlyAssignableType(objectType, null)) continue;
                membersToImplement.put(implementedMember, implementedInterface);
            }
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (Map.Entry entry : membersToImplement.entrySet()) {
            result.put(((Pair)entry.getKey()).second, entry.getValue());
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getUnimplementedMembers"));
        }
        return linkedHashMap;
    }

    private static JSType replaceThisType(JSType type, JSClass jsClass, JSTypeSource source) {
        String name;
        if (type instanceof TypeScriptGenericThisTypeImpl && (name = jsClass.getQualifiedName()) != null) {
            return new TypeScriptGenericThisTypeImpl(type.getSource(), JSNamedType.createType(name, source, JSTypeContext.INSTANCE));
        }
        return type;
    }

    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getType(), false, propertySignature.getSource());
        }
        return member;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    public static JSType setCallEnvironmentIfGenericParameterType(JSType type) {
        if (type instanceof JSGenericParameterImpl) {
            return JSGenericParameterImpl.cloneWithEnvironment((JSGenericParameterImpl)type, true);
        }
        return type;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        JSType type = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context), JSContext.INSTANCE);
        String string = TypeScriptUtil.getShortestTypeNameInContext(type, context);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        if (!((type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type))) instanceof JSNamedType) || context == null || type instanceof JSPrimitiveType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
            }
            return string;
        }
        String text = type.getResolvedTypeText();
        String string = TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context, text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context, @NotNull String startQName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        if (startQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startQName", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(startQName);
        if (name.getParent() == null) {
            String string = startQName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
            }
            return string;
        }
        String result = null;
        String qName = null;
        for (JSQualifiedNameImpl current = name; current != null && (StringUtil.isEmpty(result) || !StringUtil.equals((CharSequence)startQName, result)); current = current.getParent()) {
            String currentName = StringUtil.unquoteString((String)current.getName());
            qName = qName == null ? currentName : currentName + "." + qName;
            result = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType(qName, context);
        }
        if (result != null && StringUtil.equals((CharSequence)startQName, result)) {
            String string = qName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && (value.contains("'") || value.contains("\""));
    }

    public static File getTypeScriptCompilerFolderFile() {
        try {
            String jarPath = PathUtil.getJarPathForClass(TypeScriptUtil.class);
            if (!jarPath.endsWith(".jar")) {
                URL resource = TypeScriptUtil.class.getClassLoader().getResource(COMPILER_DIRECTORY_NAME);
                if (resource == null) {
                    throw new RuntimeException("Cannot find file compiler implementation");
                }
                return new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, COMPILER_DIRECTORY_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveIsStrict"));
        }
        JSExpression qualifier = node.getQualifier();
        return TypeScriptUtil.qualifierTypeIsExplicitlyDeclared(qualifier);
    }

    public static boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        JSType jsType;
        if (qualifier instanceof JSThisExpression && JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass || qualifier instanceof JSSuperExpression || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve = result.getElement();
                if (!(resolve instanceof TypeScriptModule) && !(resolve instanceof TypeScriptImportStatement) && !(resolve instanceof ES6ImportedBinding) && !(resolve instanceof ES6ImportSpecifierAlias) && !(resolve instanceof JSFile)) continue;
                return true;
            }
        }
        return TypeScriptUtil.isStrictType(jsType = JSResolveUtil.getExpressionJSType(qualifier));
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type) {
        if (TypeScriptUtil.isStrictType(type)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(JSType jsType) {
        return jsType != null && jsType.getSource().isExplicitlyDeclared() && !JSTypeUtils.hasAnyType(jsType) && !(jsType instanceof JSNullType);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isUnderNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isUnderNodeModules"));
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project);
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isDefinitionFile"));
        }
        return TypeScriptUtil.isDefinitionFile(file.getName());
    }

    public static boolean isDefinitionFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isDefinitionFile"));
        }
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)TYPESCRIPT_DECLARATIONS_FILE_EXTENSION) || StringUtil.endsWithIgnoreCase((String)fileName, (String)TYPESCRIPT_DECLARATIONS_JSX_FILE_EXTENSION);
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source) {
        if (source == null || !DialectDetector.isTypeScript(source)) {
            return null;
        }
        return TypeScriptUtil.getTypeMembers(source, "Function");
    }

    private static JSRecordType getTypeMembers(@NotNull PsiElement source, @NotNull String className) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getTypeMembers"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getTypeMembers"));
        }
        ArrayList members = ContainerUtil.newArrayList();
        PsiElement context = ES6PsiUtil.getNonStrictExportScope(source);
        if (context == null) {
            context = source;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(className, context);
        for (PsiElement psiElement : elements) {
            JSElement container = ES6PsiUtil.getExportScope(psiElement);
            if (!(psiElement instanceof JSClass) || container == null || ES6PsiUtil.isExternalModule((PsiElement)container) || TypeScriptModuleAccessibilityChecker.INSTANCE.check(context, psiElement) != null || TypeScriptConfigAccessibilityChecker.INSTANCE.check(context, psiElement) != null) continue;
            JSRecordType current = TypeScriptTypeParser.buildTypeFromClass((JSClass)psiElement, false);
            members.addAll(current.getTypeMembers());
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), members);
    }

    @NotNull
    public static String getFileNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getFileNameWithoutExtension"));
        }
        String extension = JSFileReference.findExtension(name, TYPESCRIPT_EXTENSIONS);
        if (extension != null) {
            String string = TypeScriptUtil.getNameWithoutExtension(name, extension);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getFileNameWithoutExtension"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getFileNameWithoutExtension"));
        }
        return string;
    }

    public static String getNameWithoutExtension(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNameWithoutExtension"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNameWithoutExtension"));
        }
        return name.substring(0, name.length() - extension.length());
    }

    public static interface JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass<?> var1, @NotNull JSTypeSubstitutor var2, boolean var3);
    }
}

