/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JavaScriptUnwrapDescriptor
implements UnwrapDescriptor {
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(Project project, Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement previous = null;
        List<Pair<PsiElement, Unwrapper>> result = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            JSBasicUnwrapper unwrapper = null;
            if (element instanceof JSBlockStatement) {
                if (parent instanceof JSBlockStatement || parent instanceof JSFile) {
                    unwrapper = new JSBlockUnwrapper();
                } else if (parent instanceof JSLoopStatement) {
                    unwrapper = new JSLoopUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                } else if (parent instanceof JSIfStatement) {
                    unwrapper = element == ((JSIfStatement)parent).getThen() ? new JSIfUnwrapper() : new JSElseUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                } else if (parent instanceof JSTryStatement) {
                    unwrapper = new JSTryUnwrapper();
                    element = parent;
                    parent = parent.getParent();
                }
                if (unwrapper != null) {
                    unwrapper.setBlockWithinSingleOperatorParent(parent instanceof JSIfStatement || parent instanceof JSLoopStatement);
                }
            } else if (element instanceof JSIfStatement) {
                JSIfStatement ifstatement = (JSIfStatement)element;
                if (!(previous instanceof JSBlockStatement)) {
                    unwrapper = ifstatement.getElse() == previous ? new JSBasicElseUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSIfStatement)elt).getElse().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSIfStatement)elt).getElse().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    } : (ifstatement.getThen() instanceof JSBlockStatement ? new JSIfUnwrapper() : new JSIfUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSIfStatement)elt).getThen().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSIfStatement)elt).getThen().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    });
                }
            } else if (element instanceof JSLoopStatement) {
                if (!(previous instanceof JSBlockStatement)) {
                    unwrapper = ((JSLoopStatement)element).getBody() instanceof JSBlockStatement ? new JSLoopUnwrapper() : new JSBasicLoopUnwrapper(){

                        @Override
                        protected TextRange getReplacedRangeStart(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(range.getStartOffset(), ((JSLoopStatement)elt).getBody().getTextRange().getStartOffset());
                        }

                        @Override
                        protected TextRange getReplacedRangeEnd(PsiElement elt) {
                            TextRange range = elt.getTextRange();
                            return new TextRange(((JSLoopStatement)elt).getBody().getTextRange().getEndOffset(), range.getEndOffset());
                        }
                    };
                }
            } else if (element instanceof JSTryStatement && !(previous instanceof JSBlockStatement)) {
                unwrapper = new JSTryUnwrapper();
            }
            result = this.addUnwrapper(element, result, unwrapper);
            previous = element;
            element = parent;
            if (!(element instanceof JSFunction)) continue;
            break;
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private List<Pair<PsiElement, Unwrapper>> addUnwrapper(PsiElement element, List<Pair<PsiElement, Unwrapper>> result, JSBasicUnwrapper unwrapper) {
        if (unwrapper != null) {
            if (result == null) {
                result = new ArrayList<Pair<PsiElement, Unwrapper>>(2);
            }
            result.add((Pair<PsiElement, Unwrapper>)new Pair((Object)element, (Object)unwrapper));
        }
        return result;
    }

    public boolean showOptionsDialog() {
        return true;
    }

    public boolean shouldTryToRestoreCaretPosition() {
        return false;
    }

    private static class JSTryUnwrapper
    extends JSBasicUnwrapper {
        private JSTryUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "try";
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSTryStatement loop = (JSTryStatement)elt;
            return new TextRange(loop.getFirstChild().getTextOffset(), loop.getStatement().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            PsiElement child = ((JSTryStatement)elt).getStatement().getLastChild();
            return new TextRange(child.getTextOffset(), elt.getTextRange().getEndOffset());
        }
    }

    private static class JSLoopUnwrapper
    extends JSBasicLoopUnwrapper {
        private JSLoopUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSLoopStatement loop = (JSLoopStatement)elt;
            return new TextRange(loop.getFirstChild().getTextOffset(), loop.getBody().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return ((JSLoopStatement)elt).getBody().getLastChild().getTextRange();
        }
    }

    private static abstract class JSBasicLoopUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicLoopUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return e instanceof JSWhileStatement ? "while" : (e instanceof JSForStatement ? "for" : (e instanceof JSForInStatement ? "for-in" : "loop"));
        }
    }

    private static class JSElseUnwrapper
    extends JSBasicElseUnwrapper {
        private JSElseUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            JSIfStatement ifStatement = (JSIfStatement)elt;
            return new TextRange(ifStatement.getFirstChild().getTextOffset(), ifStatement.getElse().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return ((JSIfStatement)elt).getElse().getLastChild().getTextRange();
        }
    }

    private static class JSIfUnwrapper
    extends JSBasicIfUnwrapper {
        private JSIfUnwrapper() {
        }

        @Override
        protected TextRange getReplacedRangeStart(PsiElement elt) {
            return new TextRange(elt.getTextRange().getStartOffset(), ((JSIfStatement)elt).getThen().getFirstChild().getTextRange().getEndOffset());
        }

        @Override
        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            PsiElement child = ((JSIfStatement)elt).getThen().getLastChild();
            return new TextRange(child.getTextOffset(), elt.getLastChild().getTextRange().getEndOffset());
        }
    }

    private static class JSBlockUnwrapper
    extends JSBasicUnwrapper {
        private JSBlockUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "block";
        }
    }

    private static abstract class JSBasicUnwrapper
    implements Unwrapper {
        private boolean myBlockWithinSingleOperatorParent;

        private JSBasicUnwrapper() {
        }

        public String getDescription(PsiElement e) {
            return "Unwrap '" + this.getKind(e) + "...'";
        }

        public boolean isApplicableTo(PsiElement e) {
            return true;
        }

        public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result) {
        }

        public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
            TextRange codeLeftRange = new TextRange(this.getReplacedRangeStart(e).getEndOffset(), this.getReplacedRangeEnd(e).getStartOffset());
            PsiElement l = PsiTreeUtil.firstChild((PsiElement)e);
            while (l != null) {
                if (codeLeftRange.contains(l.getTextRange())) {
                    toExtract.add(l);
                }
                l = PsiTreeUtil.nextLeaf((PsiElement)l);
            }
            return e;
        }

        public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
            TextRange range;
            int rangeMarkerEndOffset;
            RangeMarker rangeMarker;
            TextRange replacedRangeEnd = this.getReplacedRangeEnd(element);
            TextRange replacedRangeStart = this.getReplacedRangeStart(element);
            PsiFile containingFile = element.getContainingFile();
            Document document = editor.getDocument();
            int rangeMarkerStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)replacedRangeStart.getEndOffset(), (String)" \t\n");
            RangeMarker rangeMarker2 = rangeMarker = rangeMarkerStartOffset < (rangeMarkerEndOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(replacedRangeEnd.getStartOffset() - 1), (String)" \t\n") + 1) ? document.createRangeMarker(rangeMarkerStartOffset, rangeMarkerEndOffset) : document.createRangeMarker(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset());
            if (this.myBlockWithinSingleOperatorParent) {
                replacedRangeEnd = new TextRange(replacedRangeEnd.getStartOffset() + 1, replacedRangeEnd.getEndOffset());
                replacedRangeStart = new TextRange(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset() - 1);
            }
            document.replaceString(replacedRangeEnd.getStartOffset(), replacedRangeEnd.getEndOffset(), (CharSequence)"");
            document.replaceString(replacedRangeStart.getStartOffset(), replacedRangeStart.getEndOffset(), (CharSequence)"");
            PsiDocumentManager.getInstance((Project)editor.getProject()).commitDocument(document);
            int startOffset = Math.max(0, CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)replacedRangeStart.getStartOffset(), (String)" \t\n"));
            int endOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)replacedRangeEnd.getEndOffset(), (String)" \t\n");
            FormatFixer.doReformat(containingFile, startOffset, endOffset);
            PsiDocumentManager.getInstance((Project)editor.getProject()).commitDocument(document);
            PsiElement at = rangeMarker.isValid() ? containingFile.findElementAt(rangeMarker.getStartOffset()) : null;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            TextRange changedRange = TextRange.create((Segment)rangeMarker);
            while (at != null && (range = at.getTextRange()).getStartOffset() <= changedRange.getEndOffset()) {
                if (changedRange.contains(range)) {
                    elements.add(at);
                }
                at = PsiTreeUtil.nextLeaf((PsiElement)at);
            }
            return elements;
        }

        protected TextRange getReplacedRangeStart(PsiElement elt) {
            return elt.getFirstChild().getTextRange();
        }

        protected TextRange getReplacedRangeEnd(PsiElement elt) {
            return elt.getLastChild().getTextRange();
        }

        protected abstract String getKind(PsiElement var1);

        public void setBlockWithinSingleOperatorParent(boolean blockWithinSingleOperatorParent) {
            this.myBlockWithinSingleOperatorParent = blockWithinSingleOperatorParent;
        }
    }

    private static abstract class JSBasicElseUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicElseUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "else";
        }
    }

    private static abstract class JSBasicIfUnwrapper
    extends JSBasicUnwrapper {
        private JSBasicIfUnwrapper() {
        }

        @Override
        protected String getKind(PsiElement e) {
            return "if";
        }
    }
}

