/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSAutocompleteCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckContentsCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCoverageCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSFindModuleCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSGetDefinitionCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSStatusCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSTypeInfoCommand;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerService
extends JSLanguageServiceBase
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    public static final long SMALL_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final long MIDDLE_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    public static final long LARGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long COMPLETION_TIMEOUT_MILLIS = 1000L;
    @NotNull
    private final Set<VirtualFile> myServerPaths;
    @NotNull
    private final JSLanguageServiceDefaultCacheData myCacheData;

    public FlowJSServerService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "<init>"));
        }
        super(project);
        this.myServerPaths = ContainerUtil.newConcurrentSet();
        this.myCacheData = new JSLanguageServiceDefaultCacheData(){

            public int hashCode() {
                return FlowJSServerService.this.myProject.hashCode();
            }

            @Override
            @Nullable
            public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/flow/FlowJSServerService$1", "updateCacheAndGetServiceObject"));
                }
                return new JSLanguageServiceObject(){};
            }
        };
    }

    @Override
    protected long getAliveCheckTimeout() {
        return TimeUnit.SECONDS.toMillis(60L);
    }

    @Override
    protected boolean needInitToolWindow() {
        return FlowJSServerService.getService(this.myProject) != null;
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getProcessName"));
        }
        return "Flow";
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return FlowJSToolWindowProvider.getToolWindow(this.myProject);
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        FlowJSStandardOutputProtocol protocol = new FlowJSStandardOutputProtocol(this.myProject);
        return new JSLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, this.myDefaultReporter, this.myCacheData);
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "getService"));
        }
        if (project.isDisposed() || !project.isOpen()) {
            return null;
        }
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(project).getFlowSettings();
        if (!settings.isTypeCheckingEnabled()) {
            return null;
        }
        String flowPath = settings.getFlowExecutablePath();
        if (StringUtil.isEmpty((String)flowPath)) {
            return null;
        }
        FlowJSServerService service = FlowJSServerService.getInitializedService(project);
        if (service == null || !service.checkCanUseService()) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(flowPath);
        JSLanguageServiceToolWindowManager flowJSToolWindowProvider = FlowJSToolWindowProvider.getToolWindow(project);
        if (virtualFile == null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (flowJSToolWindowProvider != null) {
                    ImmutableList<JSAnnotationError> results = JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0]));
                    flowJSToolWindowProvider.logProjectErrors(results, true);
                }
            });
            return null;
        }
        return service;
    }

    public static FlowJSServerService getInitializedService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "getInitializedService"));
        }
        return (FlowJSServerService)ServiceManager.getService((Project)project, FlowJSServerService.class);
    }

    @Nullable
    public <T> Future<T> sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor, @NotNull FlowJSConfig config) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceQueue.State state = process.getState();
        if (state == JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT || state == JSLanguageServiceQueue.State.DISPOSED) {
            return null;
        }
        this.myServerPaths.add(config.getConfigDirectory());
        return process.execute(command, processor);
    }

    @Nullable
    public FlowJSConfig getConfig(@NotNull VirtualFile file) {
        Collection<FlowJSConfig> configCollection;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getConfig"));
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        if (configService != null && (configCollection = configService.getConfigOfFile(file)).size() >= 1) {
            return FlowJSServerService.getClosestConfig(configCollection, file);
        }
        return null;
    }

    private static FlowJSConfig getClosestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file) {
        if (configCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configCollection", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        HashSet filePathElements = ContainerUtil.newHashSet();
        FlowJSServerService.addAllElements(file, filePathElements);
        int diffForFile = Integer.MAX_VALUE;
        int diffForConfig = Integer.MAX_VALUE;
        FlowJSConfig closestConfig = (FlowJSConfig)ContainerUtil.getFirstItem(configCollection);
        for (FlowJSConfig config : configCollection) {
            HashSet configPathElements = ContainerUtil.newHashSet();
            FlowJSServerService.addAllElements(config.getConfigDirectory(), configPathElements);
            HashSet configPathElementsCopy = ContainerUtil.newHashSet();
            configPathElementsCopy.addAll(configPathElements);
            HashSet filePathElementsCopy = ContainerUtil.newHashSet();
            filePathElementsCopy.addAll(filePathElements);
            filePathElementsCopy.removeAll(configPathElements);
            configPathElementsCopy.removeAll(filePathElements);
            if (diffForConfig == 0) {
                if (diffForFile <= filePathElementsCopy.size()) continue;
                diffForFile = filePathElementsCopy.size();
                closestConfig = config;
                continue;
            }
            long currentSum = diffForConfig + diffForFile;
            long tempSum = filePathElementsCopy.size() + configPathElementsCopy.size();
            if (configPathElementsCopy.size() != 0 && currentSum <= tempSum) continue;
            diffForConfig = configPathElementsCopy.size();
            diffForFile = filePathElementsCopy.size();
            closestConfig = config;
        }
        return closestConfig;
    }

    private static void addAllElements(@NotNull VirtualFile file, Set<String> filePathElements) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "addAllElements"));
        }
        for (String element : file.getPath().split("/")) {
            if (!StringUtil.isEmpty((String)element) || element.equals(file.getName())) continue;
            filePathElements.add(element);
        }
    }

    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        FlowJSServerService.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSGetDefinitionCommand commandWithArgument = new FlowJSGetDefinitionCommand(request, document.getText(), path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromDefinitionCommandAnswer(requestAnswer, virtualFile);
    }

    @Nullable
    private PsiElement getPsiElementFromDefinitionCommandAnswer(@NotNull List<JsonObject> answer, @NotNull VirtualFile currentFile) {
        VirtualFile virtualFile;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (answer.isEmpty()) {
            return null;
        }
        JsonObject answerJson = answer.get(0);
        if (answerJson == null) {
            return null;
        }
        JsonElement path = answerJson.get("path");
        if (path.getAsString().isEmpty()) {
            return null;
        }
        int startLine = answerJson.get("line").getAsInt() - 1;
        int startColumn = answerJson.get("start").getAsInt() - 1;
        if (startLine >= 0 && startColumn >= 0 && (virtualFile = !path.getAsString().equals("-") ? LocalFileSystem.getInstance().findFileByPath(path.getAsString()) : currentFile) != null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            try {
                FileViewProvider provider = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile);
                if (provider == null) {
                    return null;
                }
                Document document = provider.getDocument();
                if (document != null) {
                    int offset = document.getLineStartOffset(startLine) + startColumn;
                    if (psiFile != null) {
                        return psiFile.findElementAt(offset);
                    }
                }
            }
            catch (NullPointerException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public PsiElement findModuleOfElement(@NotNull VirtualFile file, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(request, config);
        request.add(StringUtil.unquoteString((String)element.getText()));
        request.add(file.getPath());
        VirtualFile parent = file.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSFindModuleCommand commandWithArgument = new FlowJSFindModuleCommand(request, null, path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromFindModuleCommandAnswer(requestAnswer);
    }

    @Nullable
    private PsiElement getPsiElementFromFindModuleCommandAnswer(List<JsonObject> answerList) {
        JsonObject answer;
        if (!answerList.isEmpty() && (answer = answerList.get(0)).has("file")) {
            String path = answer.get("file").getAsString();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            }
        }
        return null;
    }

    public String getTypeOfElement(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull FlowJSConfig config) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        FlowJSServerService.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        VirtualFile parent = virtualFile.getParent();
        String path = parent.getCanonicalPath();
        if (path == null) {
            return null;
        }
        FlowJSTypeInfoCommand commandWithArgument = new FlowJSTypeInfoCommand(request, document.getText(), path);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, SMALL_TIMEOUT);
        return FlowJSServerService.getTypeFromAnswer(requestAnswer);
    }

    @NotNull
    private static String getTypeFromAnswer(List<JsonObject> answer) {
        JsonObject answerJson;
        String type = "";
        if (!answer.isEmpty() && (answerJson = answer.get(0)).has("type")) {
            type = answerJson.get("type").getAsString();
        }
        String string = type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeFromAnswer"));
        }
        return string;
    }

    private static void setCommandLineParams(List<String> request, FlowJSConfig config) {
        request.add("--root");
        request.add(config.getConfigDirectory().getPath());
        request.add("--json");
    }

    @NotNull
    public List<JsonObject> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull FlowJSConfig config, @NotNull CompletionParameters parameters, @NotNull String text) {
        String filePath;
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(request, config);
        request.add(originalFile.getVirtualFile().getCanonicalPath());
        PsiDirectory directory = originalFile.getContainingDirectory();
        String string = filePath = directory != null ? directory.getVirtualFile().getPath() : originalFile.getProject().getBasePath();
        if (filePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
            }
            return list;
        }
        int line = document.getLineNumber(parameters.getOffset());
        request.add(String.valueOf(line + 1));
        request.add(String.valueOf(parameters.getOffset() - document.getLineStartOffset(line) + "IntellijIdeaRulezzz ".length()));
        FlowJSAutocompleteCommand commandWithArgument = new FlowJSAutocompleteCommand(request, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        JSLanguageServiceUtil.awaitFuture(future, 1000L, 10L, null);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        return arrayList;
    }

    @NotNull
    public List<JsonObject> checkContentOfFile(@NotNull FlowJSConfig config, @NotNull String text, @NotNull String fileName, @NotNull String filePath) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(parameterList, config);
        parameterList.add(fileName);
        FlowJSCheckContentsCommand commandWithArgument = new FlowJSCheckContentsCommand(parameterList, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        return arrayList;
    }

    public List<JSAnnotationError> getAllErrors() {
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        ArrayList<JSAnnotationError> allErrors = new ArrayList<JSAnnotationError>();
        if (configService != null) {
            Collection<FlowJSConfig> configFiles = configService.getConfigFiles();
            FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
            if (fileIndexFacade != null) {
                configFiles.forEach(config -> allErrors.addAll(this.getErrorsFromDir((FlowJSConfig)config)));
            }
        }
        return allErrors;
    }

    public static List<JSAnnotationError> parseFlowErrors(@NotNull JsonObject json, @Nullable String filePath) {
        JsonElement hasErrors;
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseFlowErrors"));
        }
        ArrayList<JSAnnotationError> listOfErrors = new ArrayList<JSAnnotationError>();
        VirtualFile currentVirtualFile = null;
        if (filePath != null) {
            currentVirtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if ((hasErrors = json.get("passed")) != null && !hasErrors.getAsBoolean()) {
            try {
                JsonArray errorArray = json.getAsJsonArray("errors");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    int line = 0;
                    int column = 0;
                    int lineEnd = 0;
                    int columnEnd = 0;
                    StringBuilder errorText = new StringBuilder();
                    String localFilePath = null;
                    String errorCategory = errorObject.get("level").getAsString();
                    JsonArray messageArray = errorObject.getAsJsonArray("message");
                    boolean isFirst = true;
                    for (JsonElement message : messageArray) {
                        JsonObject messageObject = message.getAsJsonObject();
                        if (messageObject.get("type").getAsString().equals("Blame")) {
                            String currentFilePath = messageObject.get("path").getAsString();
                            if (currentFilePath == null) continue;
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(currentFilePath);
                            if (currentVirtualFile == null || currentVirtualFile.equals(virtualFile)) {
                                localFilePath = currentFilePath;
                                JsonObject loc = messageObject.get("loc").getAsJsonObject();
                                JsonObject start = loc.get("start").getAsJsonObject();
                                JsonObject end = loc.get("end").getAsJsonObject();
                                if (line == 0) {
                                    line = start.get("line").getAsInt();
                                    column = start.get("column").getAsInt();
                                    lineEnd = end.get("line").getAsInt();
                                    columnEnd = end.get("column").getAsInt();
                                }
                            }
                        }
                        if (isFirst) {
                            errorText.append("Flow: ");
                        }
                        errorText.append(messageObject.get("descr").getAsString());
                        if (!isFirst) {
                            errorText.append(" ");
                        }
                        if (!isFirst || messageArray.size() <= 1) continue;
                        errorText.append(". ");
                        isFirst = false;
                    }
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(errorText.toString(), localFilePath != null && !localFilePath.isEmpty() ? localFilePath : filePath, errorCategory, line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    private List<JSAnnotationError> getErrorsFromDir(@NotNull FlowJSConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getErrorsFromDir"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add("--json");
        FlowJSStatusCommand commandWithArgument = new FlowJSStatusCommand(parameterList, config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList<JSAnnotationError> errors = new ArrayList<JSAnnotationError>();
        if (requestAnswer.size() > 0) {
            errors.addAll(FlowJSServerService.parseFlowErrors((JsonObject)requestAnswer.get(0), null));
        }
        return errors;
    }

    public List<JSAnnotationError> getCoverageOfFile(@NotNull FlowJSConfig config, @NotNull PsiFile originalFile) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        FlowJSServerService.setCommandLineParams(parameterList, config);
        parameterList.add(originalFile.getVirtualFile().getPath());
        FlowJSCoverageCommand commandWithArgument = new FlowJSCoverageCommand(parameterList, originalFile.getText(), config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList errors = ContainerUtil.newArrayList();
        if (!requestAnswer.isEmpty()) {
            errors.addAll(FlowJSServerService.parseCoverageError((JsonObject)requestAnswer.get(0)));
        }
        return errors;
    }

    private static List<JSLanguageServiceAnnotationResult> parseCoverageError(@NotNull JsonObject json) {
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseCoverageError"));
        }
        ArrayList listOfErrors = ContainerUtil.newArrayList();
        JsonElement expression = json.get("expressions");
        if (expression != null) {
            try {
                JsonArray errorArray = expression.getAsJsonObject().getAsJsonArray("uncovered_locs");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    String source = errorObject.get("source").getAsString();
                    JsonObject start = errorObject.get("start").getAsJsonObject();
                    JsonObject end = errorObject.get("end").getAsJsonObject();
                    int line = start.get("line").getAsInt();
                    int column = start.get("column").getAsInt();
                    int lineEnd = end.get("line").getAsInt();
                    int columnEnd = end.get("column").getAsInt();
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(JSBundle.message((String)"js.flowjs.coverage.inspection.error.text", (Object[])new Object[0]), source != null ? source : "", "Warning", line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    public static boolean awaitFuture(@Nullable Future<Boolean> future, long period) {
        if (future == null) {
            return false;
        }
        try {
            future.get(period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return future.isDone();
    }

    public static void saveSyncAllUnsavedFiles(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveSyncAllUnsavedFiles"));
        }
        List<Document> toSave = FlowJSServerService.getUnsavedFlowDocuments(exceptThis);
        if (!toSave.isEmpty()) {
            ApplicationManager.getApplication().invokeAndWait(() -> FlowJSServerService.saveFiles(toSave));
        }
    }

    @NotNull
    private static List<Document> getUnsavedFlowDocuments(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "getUnsavedFlowDocuments"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile exceptThisVFile = exceptThis.getVirtualFile();
        List<Document> list = Arrays.stream(FileDocumentManager.getInstance().getUnsavedDocuments()).filter(document -> {
            VirtualFile file = documentManager.getFile(document);
            return file != null && !file.equals(exceptThisVFile) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getUnsavedFlowDocuments"));
        }
        return list;
    }

    public static boolean saveAsyncAllUnsavedFiles(@NotNull Runnable restartService, @NotNull PsiFile exceptThis) {
        if (restartService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restartService", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveAsyncAllUnsavedFiles"));
        }
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveAsyncAllUnsavedFiles"));
        }
        List<Document> toSave = FlowJSServerService.getUnsavedFlowDocuments(exceptThis);
        if (!toSave.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (restartService == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restartService", "com/intellij/lang/javascript/flow/FlowJSServerService", "lambda$saveAsyncAllUnsavedFiles$11"));
                }
                FlowJSServerService.saveFiles(toSave);
                restartService.run();
            });
            return true;
        }
        return false;
    }

    private static void saveFiles(Collection<Document> unsavedDocuments) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : unsavedDocuments) {
            fileDocumentManager.saveDocument(document);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myServerPaths.forEach(this::stopFlowServer);
        this.myServerPaths.clear();
    }

    @Override
    protected Runnable getDisposeQueueRunnableUnderLock(@NotNull JSLanguageServiceQueue serviceToDispose) {
        if (serviceToDispose == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceToDispose", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDisposeQueueRunnableUnderLock"));
        }
        Runnable runnable = super.getDisposeQueueRunnableUnderLock(serviceToDispose);
        HashSet files = ContainerUtil.newHashSet(this.myServerPaths);
        if (files.isEmpty()) {
            return runnable;
        }
        this.myServerPaths.clear();
        return () -> {
            runnable.run();
            files.forEach(this::stopFlowServer);
        };
    }

    private void stopFlowServer(@NotNull VirtualFile directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/javascript/flow/FlowJSServerService", "stopFlowServer"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String path = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings().getFlowExecutablePath();
        if (path.isEmpty() || StringUtil.isEmpty((String)directory.getCanonicalPath())) {
            return;
        }
        commandLine.setExePath(path);
        commandLine.withWorkDirectory(directory.getCanonicalPath());
        commandLine.addParameter("stop");
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public static String isFlowServerAvailable(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/flow/FlowJSServerService", "isFlowServerAvailable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "isFlowServerAvailable"));
        }
        if (path.isEmpty()) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.empty", (Object[])new Object[0]);
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.addParameter("version");
        line.addParameter("--json");
        line.setWorkDirectory(project.getBasePath());
        final Ref answer = new Ref();
        final Ref answerReceived = Ref.create((Object)Boolean.FALSE);
        if (!FileUtil.exists((String)path)) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error", (Object[])new Object[0]);
        }
        try {
            OSProcessHandler handler = new OSProcessHandler(line);
            final StringBuilder resultJson = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        answerReceived.set((Object)Boolean.TRUE);
                        String text = event.getText();
                        resultJson.append(text);
                        JsonElement element = FlowJSStandardOutputProtocol.parseJsonSafe(resultJson.toString());
                        if (element != null) {
                            answer.set(null);
                        } else {
                            answer.set((Object)JSBundle.message((String)"js.flow.enable.flow.service.error.invalid.json", (Object[])new Object[]{resultJson}));
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        answerReceived.set((Object)Boolean.TRUE);
                        answer.set((Object)event.getText());
                    }
                }
            });
            handler.startNotify();
            if (handler.waitFor()) {
                if (((Boolean)answerReceived.get()).booleanValue() && answer.get() == null) {
                    return null;
                }
                return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{(Boolean)answerReceived.get() != false ? answer.get() : "Empty process output"});
            }
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Process doesn't respond"});
        }
        catch (ExecutionException e) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{e.getMessage()});
        }
    }

    @NotNull
    public static List<String> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        String execFileName = FlowJSServerService.getFlowExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)infos, "flow-bin", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            VirtualFile moduleDir = info.getVirtualFile();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || moduleDir == null) continue;
            VirtualFile execFile = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"..", ".bin", execFileName});
            if (execFile != null && !execFile.isDirectory()) {
                paths.add(execFile.getPath());
                continue;
            }
            VirtualFile execFileInVendor = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"vendor", execFileName});
            if (execFileInVendor == null || execFileInVendor.isDirectory()) continue;
            paths.add(execFileInVendor.getPath());
        }
        ContainerUtil.removeDuplicates((Collection)paths);
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "calcPossibleFlowExecutableFiles"));
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    private static String getFlowExecutableFilename() {
        String string = SystemInfo.isWindows ? "flow.exe" : "flow";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getFlowExecutableFilename"));
        }
        return string;
    }
}

