/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigUtil {
    @Nullable
    public static String getRegularExpressionForGlobPattern(@NotNull Collection<String> specs, @NotNull VirtualFile baseDirectory) {
        if (specs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specs", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "getRegularExpressionForGlobPattern"));
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "getRegularExpressionForGlobPattern"));
        }
        ArrayList correctSpecs = ContainerUtil.newArrayList();
        specs.forEach(file -> {
            if (baseDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "lambda$getRegularExpressionForGlobPattern$0"));
            }
            correctSpecs.add(FileUtil.toCanonicalPath((String)(baseDirectory.getCanonicalPath() + "/" + file)));
        });
        return TypeScriptConfigUtil.getRegularExpressionForGlobPattern(FlowJSConfigUtil.replaceProjectRoot(correctSpecs, baseDirectory), baseDirectory, TypeScriptConfigUtil.WildCardType.FILES);
    }

    @NotNull
    private static Collection<String> replaceProjectRoot(@NotNull Collection<String> collection, @NotNull VirtualFile baseDirectory) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "replaceProjectRoot"));
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "replaceProjectRoot"));
        }
        Collection collection2 = collection.stream().map(regex -> {
            if (baseDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "lambda$replaceProjectRoot$1"));
            }
            return StringUtil.replace((String)regex, (String)"<PROJECT_ROOT>", (String)baseDirectory.getPath());
        }).collect(Collectors.toList());
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "replaceProjectRoot"));
        }
        return collection2;
    }

    @Nullable
    public static String getRegularExpression(@NotNull Collection<String> regularExpressions, @NotNull VirtualFile baseDir) {
        if (regularExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regularExpressions", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "getRegularExpression"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigUtil", "getRegularExpression"));
        }
        StringBuilder builder = new StringBuilder();
        Collection<String> correctRootCollection = FlowJSConfigUtil.replaceProjectRoot(regularExpressions, baseDir);
        correctRootCollection.forEach(regex -> builder.append(regex + "|"));
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return "^(" + builder.toString() + ")($|\\/)";
    }
}

