/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ES6CodeStyleImportsPanel {
    @NotNull
    private final Class<? extends JSCodeStyleSettings> mySettingsClass;
    private JPanel myWholePanel;
    private JPanel myGeneralPanel;
    private JPanel mySortOptionsPanel;
    protected JBCheckBox myMergeImports;
    protected JBCheckBox mySortMembers;
    protected JBCheckBox mySortModuleName;
    protected JBCheckBox myUseAbsolutePathJBCheckBox;
    protected final JSApplicationSettings appSettings;

    @NotNull
    public static CodeStyleAbstractPanel getImportsCodeStylePanel(@NotNull CodeStyleSettings settings, final @NotNull FileType type, final @NotNull ES6CodeStyleImportsPanel panel) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getImportsCodeStylePanel"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getImportsCodeStylePanel"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getImportsCodeStylePanel"));
        }
        final JPanel jPanel = panel.getPanel();
        CodeStyleAbstractPanel codeStyleAbstractPanel = new CodeStyleAbstractPanel(settings){

            protected int getRightMargin() {
                return 0;
            }

            protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
                return null;
            }

            @NotNull
            protected FileType getFileType() {
                FileType fileType = type;
                if (fileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel$1", "getFileType"));
                }
                return fileType;
            }

            protected String getPreviewText() {
                return null;
            }

            public void apply(CodeStyleSettings settings) {
                panel.apply(settings);
            }

            public boolean isModified(CodeStyleSettings settings) {
                return panel.isModified(settings);
            }

            public JComponent getPanel() {
                return jPanel;
            }

            protected void resetImpl(CodeStyleSettings settings) {
                panel.reset(settings);
            }

            protected String getTabTitle() {
                return ApplicationBundle.message((String)"title.imports", (Object[])new Object[0]);
            }
        };
        if (codeStyleAbstractPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getImportsCodeStylePanel"));
        }
        return codeStyleAbstractPanel;
    }

    public ES6CodeStyleImportsPanel(@NotNull Class<? extends JSCodeStyleSettings> settingsClass) {
        if (settingsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsClass", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.appSettings = JSApplicationSettings.getInstance();
        this.mySettingsClass = settingsClass;
        OptionGroup generalGroup = new OptionGroup();
        this.fillGeneralPanel(generalGroup);
        this.myGeneralPanel.add((Component)generalGroup.createPanel(), "North");
        OptionGroup orderGroup = new OptionGroup();
        this.fillOrderPanel(orderGroup);
        this.mySortOptionsPanel.add((Component)orderGroup.createPanel(), "North");
    }

    protected void fillOrderPanel(@NotNull OptionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "fillOrderPanel"));
        }
        this.mySortMembers = new JBCheckBox(JSBundle.message((String)"js.import.options.sort.members", (Object[])new Object[0]));
        this.mySortModuleName = new JBCheckBox(JSBundle.message((String)"js.import.options.sort.module.name", (Object[])new Object[0]));
        group.add((JComponent)this.mySortMembers);
        group.add((JComponent)this.mySortModuleName);
    }

    protected void fillGeneralPanel(@NotNull OptionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "fillGeneralPanel"));
        }
        this.myMergeImports = new JBCheckBox(JSBundle.message((String)"js.import.options.merge.import", (Object[])new Object[0]));
        this.myUseAbsolutePathJBCheckBox = new JBCheckBox(this.getAbsolutePathCheckboxTitle());
        group.add((JComponent)this.myMergeImports);
        group.add((JComponent)this.myUseAbsolutePathJBCheckBox);
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myWholePanel, "Center");
        return panel;
    }

    public boolean isModified(@NotNull CodeStyleSettings commonSettings) {
        JSCodeStyleSettings jsSettings;
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "isModified"));
        }
        JSApplicationSettings appSettings = JSApplicationSettings.getInstance();
        return ES6CodeStyleImportsPanel.getMergeImports(appSettings, jsSettings = this.getCustomJSSettings(commonSettings)) != this.myMergeImports.isSelected() || this.getUseAbsolutePath(jsSettings) != this.myUseAbsolutePathJBCheckBox.isSelected() || jsSettings.IMPORT_SORT_MEMBERS != this.mySortMembers.isSelected() || jsSettings.IMPORT_SORT_MODULE_NAME != this.mySortModuleName.isSelected();
    }

    public void apply(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "apply"));
        }
        JSApplicationSettings appSettings = JSApplicationSettings.getInstance();
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.applyUseAbsolutePath(jsSettings, this.myUseAbsolutePathJBCheckBox.isSelected());
        ES6CodeStyleImportsPanel.applyMergeImports(appSettings, jsSettings, this.myMergeImports.isSelected());
        jsSettings.IMPORT_SORT_MEMBERS = this.mySortMembers.isSelected();
        jsSettings.IMPORT_SORT_MODULE_NAME = this.mySortModuleName.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "reset"));
        }
        JSApplicationSettings appSettings = JSApplicationSettings.getInstance();
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.myUseAbsolutePathJBCheckBox.setSelected(this.getUseAbsolutePath(jsSettings));
        this.myMergeImports.setSelected(ES6CodeStyleImportsPanel.getMergeImports(appSettings, jsSettings));
        this.mySortMembers.setSelected(jsSettings.IMPORT_SORT_MEMBERS);
        this.mySortModuleName.setSelected(jsSettings.IMPORT_SORT_MODULE_NAME);
    }

    private static void applyMergeImports(@NotNull JSApplicationSettings appSettings, @NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (appSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "applyMergeImports"));
        }
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "applyMergeImports"));
        }
        if (appSettings.isMergeImports() == value) {
            jsSettings.IMPORT_MERGE_MEMBERS = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_MERGE_MEMBERS = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    @NotNull
    protected String getAbsolutePathCheckboxTitle() {
        String string = JSBundle.message((String)"javascript.import.options.use.resource.root", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getAbsolutePathCheckboxTitle"));
        }
        return string;
    }

    private static boolean getMergeImports(@NotNull JSApplicationSettings appSettings, @NotNull JSCodeStyleSettings jsSettings) {
        if (appSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getMergeImports"));
        }
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getMergeImports"));
        }
        JSCodeStyleSettings.BooleanWithGlobalOption value = jsSettings.IMPORT_MERGE_MEMBERS;
        return value == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? appSettings.isMergeImports() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    @NotNull
    protected JSCodeStyleSettings getCustomJSSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getCustomJSSettings"));
        }
        JSCodeStyleSettings jSCodeStyleSettings = (JSCodeStyleSettings)settings.getCustomSettings(this.mySettingsClass);
        if (jSCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getCustomJSSettings"));
        }
        return jSCodeStyleSettings;
    }

    private boolean getUseAbsolutePath(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "getUseAbsolutePath"));
        }
        JSCodeStyleSettings.BooleanWithGlobalOption value = jsSettings.IMPORT_PREFER_ABSOLUTE_PATH;
        return value == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? this.appSettings.isUseAbsoluteConfigPath() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    private void applyUseAbsolutePath(@NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (jsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsSettings", "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel", "applyUseAbsolutePath"));
        }
        if (this.appSettings.isUseAbsoluteConfigPath() == value) {
            jsSettings.IMPORT_PREFER_ABSOLUTE_PATH = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_PREFER_ABSOLUTE_PATH = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        this.myGeneralPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(-1, -1));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySortOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

