/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JSCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    protected JCheckBox myIndentPackageChildren;
    private JPanel myPreviewPanel;
    protected JTextField myFieldPrefixTextField;
    protected JTextField myPropertyPrefixTextField;
    protected JPanel myNamingConventionsPane;
    private JComboBox myAlignObjectPropertiesCombo;
    private JCheckBox myFormatCStyleCommentsBox;
    private JPanel myCodeCommentingPanel;
    private JPanel myAlignAssignmentsPanel;
    private JBRadioButton myAlignAssignmentsNoneButton;
    private JBRadioButton myAlignEachVarStatementButton;
    private JRadioButton myAlignAssignmentGroupsButton;
    protected JPanel myGeneratedOptionsPanel;
    protected JBCheckBox myUsePublicModifierJBCheckBox;
    private static CodeStyleSettings mySettings;
    private boolean myInsideUpdate;
    private CommenterForm myCommenterForm;

    public JSCodeStylePanel(Language language, CodeStyleSettings settings) {
        mySettings = settings;
        super(language, null, mySettings);
        this.myInsideUpdate = false;
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        this.addPanelToWatch(this.myPanel);
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!JSCodeStylePanel.this.myInsideUpdate) {
                    JSCodeStylePanel.this.somethingChanged();
                }
            }
        };
        this.myAlignObjectPropertiesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JSCodeStylePanel.this.getCustomJSSettings((CodeStyleSettings)mySettings).ALIGN_OBJECT_PROPERTIES = (Integer)JSCodeStylePanel.getComboboxValue(JSCodeStylePanel.this.myAlignObjectPropertiesCombo);
                if (!JSCodeStylePanel.this.myInsideUpdate) {
                    JSCodeStylePanel.this.somethingChanged();
                }
            }
        });
        this.myFieldPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myPropertyPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myNamingConventionsPane.setVisible(false);
        this.myIndentPackageChildren.setVisible(false);
        this.myUsePublicModifierJBCheckBox.setVisible(false);
        this.myGeneratedOptionsPanel.setVisible(false);
        this.myNamingConventionsPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"javascript.formatting.options.panel.naming.conventions", (Object[])new Object[0]), (boolean)true));
        this.myFormatCStyleCommentsBox.setMargin((Insets)JBUI.insets((int)2, (int)0, (int)2, (int)2));
        this.myAlignAssignmentsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Align 'var' statements and assignments"));
        this.myGeneratedOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"js.settings.generated.code.title", (Object[])new Object[0])));
        JSCodeStylePanel.initCombobox(this.myAlignObjectPropertiesCombo, new SimpleComboboxItem<Integer>(0, JSBundle.message((String)"js.align.properties.none", (Object[])new Object[0])), new SimpleComboboxItem<Integer>(2, JSBundle.message((String)"js.align.properties.on.colon", (Object[])new Object[0])), new SimpleComboboxItem<Integer>(1, JSBundle.message((String)"js.align.properties.on.value", (Object[])new Object[0])));
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm(this.getDefaultLanguage());
        this.myCodeCommentingPanel = this.myCommenterForm.getCommenterPanel();
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.js"), scheme, null);
    }

    protected int getRightMargin() {
        return 60;
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = JavaScriptSupportLoader.JAVASCRIPT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    protected String getPreviewText() {
        return "/*\n Multiline\n C-style\n Comment\n */\nvar myLink = {\n      img: \"btn.gif\",\n      text: \"Button\",\n      width: 128\n    },\n    local = true,\n    initial = -1;\nvar cssClasses = [\"bold\", \"red\",]\nvar selector = \"#id\";\n\nvar color = \"red\";\nvar offset = 10;\n\nvarName = val;";
    }

    public void apply(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN = this.myIndentPackageChildren.isSelected() ? 1 : 0;
        jsCodeStyleSettings.FIELD_PREFIX = this.myFieldPrefixTextField.getText();
        jsCodeStyleSettings.PROPERTY_PREFIX = this.myPropertyPrefixTextField.getText();
        jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES = (Integer)JSCodeStylePanel.getComboboxValue(this.myAlignObjectPropertiesCombo);
        jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS = this.myFormatCStyleCommentsBox.isSelected();
        jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION = this.myAlignEachVarStatementButton.isSelected();
        jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS = this.myAlignAssignmentGroupsButton.isSelected();
        jsCodeStyleSettings.USE_PUBLIC_MODIFIER = this.myUsePublicModifierJBCheckBox.isSelected();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        return jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1 != this.myIndentPackageChildren.isSelected() || !jsCodeStyleSettings.FIELD_PREFIX.equals(this.myFieldPrefixTextField.getText()) || !jsCodeStyleSettings.PROPERTY_PREFIX.equals(this.myPropertyPrefixTextField.getText()) || jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES != (Integer)JSCodeStylePanel.getComboboxValue(this.myAlignObjectPropertiesCombo) || jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS != this.myFormatCStyleCommentsBox.isSelected() || jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION != this.myAlignEachVarStatementButton.isSelected() || jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS != this.myAlignAssignmentGroupsButton.isSelected() || jsCodeStyleSettings.USE_PUBLIC_MODIFIER != this.myUsePublicModifierJBCheckBox.isSelected() || this.myCommenterForm.isModified(settings);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        try {
            this.myInsideUpdate = true;
            JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
            this.myIndentPackageChildren.setSelected(jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1);
            this.myFieldPrefixTextField.setText(jsCodeStyleSettings.FIELD_PREFIX);
            this.myPropertyPrefixTextField.setText(jsCodeStyleSettings.PROPERTY_PREFIX);
            JSCodeStylePanel.selectComboboxValue(this.myAlignObjectPropertiesCombo, jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES);
            this.myFormatCStyleCommentsBox.setSelected(jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS);
            this.myAlignAssignmentsNoneButton.setSelected(!jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS && !jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION);
            this.myAlignEachVarStatementButton.setSelected(jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION);
            this.myAlignAssignmentGroupsButton.setSelected(jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS);
            this.myUsePublicModifierJBCheckBox.setSelected(jsCodeStyleSettings.USE_PUBLIC_MODIFIER);
            this.myCommenterForm.reset(settings);
        }
        finally {
            this.myInsideUpdate = false;
        }
    }

    public static void initCombobox(JComboBox combobox, String ... items) {
        for (String object : items) {
            combobox.addItem(new SimpleComboboxItem<String>(object.toString(), object.toString()));
        }
    }

    public static <T> void initCombobox(JComboBox combobox, SimpleComboboxItem<T> ... items) {
        JSCodeStylePanel.initCombobox(combobox, ContainerUtil.list((Object[])items));
    }

    public static <T> void initCombobox(JComboBox combobox, List<SimpleComboboxItem<T>> items) {
        for (SimpleComboboxItem<T> object : items) {
            combobox.addItem(object);
        }
        if (items.size() > 0) {
            combobox.setSelectedItem(items.get(0));
        }
    }

    public static <T> T getComboboxValue(JComboBox combobox) {
        return ((SimpleComboboxItem)combobox.getSelectedItem()).getValue();
    }

    public static <T> void selectComboboxValue(JComboBox combobox, T value) {
        for (int i = 0; i < combobox.getItemCount(); ++i) {
            Object item = combobox.getItemAt(i);
            if (!(item instanceof SimpleComboboxItem) || ((SimpleComboboxItem)item).getValue() != value) continue;
            combobox.setSelectedIndex(i);
        }
    }

    protected String getFileTypeExtension(FileType fileType) {
        return "js";
    }

    protected JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel2;
        JComboBox jComboBox;
        JCheckBox jCheckBox2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), "", 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel6);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        this.myNamingConventionsPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Naming conventions", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Field prefix:");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldPrefixTextField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Property prefix:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertyPrefixTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myGeneratedOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Generated code options", 0, 0, null, null));
        this.myUsePublicModifierJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.generated.use.public.modifier"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myIndentPackageChildren = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("to.indent.package.statement.children"));
        jCheckBox2.setMargin(new Insets(2, 0, 2, 2));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.align.properties"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAlignObjectPropertiesCombo = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myAlignAssignmentsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Align 'var' statements and assignments", 0, 0, null, null));
        this.myAlignAssignmentsNoneButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Do not align");
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignEachVarStatementButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Align multiline 'var' statements");
        jPanel2.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignAssignmentGroupsButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Align multiple 'var' statements and assignments");
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = this.myCodeCommentingPanel;
        jPanel6.add((Component)jPanel8, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFormatCStyleCommentsBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.format.cstyle.comments"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 5, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class SimpleComboboxItem<T> {
        private String myTitle;
        private T myValue;

        public SimpleComboboxItem(T value, String title) {
            this.myValue = value;
            this.myTitle = title;
        }

        public T getValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myTitle;
        }
    }
}

