/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import com.intellij.webcore.formatter.comments.CommentWrapper;
import com.intellij.webcore.formatter.comments.DocCommentLineDataBuilder;
import com.intellij.webcore.formatter.comments.LineCommentLineDataBuilder;
import org.jetbrains.annotations.NotNull;

public class JSCommentPostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processElement"));
        }
        Language sourceLang = source.getLanguage();
        if (source.isValid() && sourceLang.isKindOf((Language)JavascriptLanguage.INSTANCE) && JSCommentPostFormatProcessor.shouldWrapLongLines(settings, sourceLang)) {
            return new JSCommentVisitor(settings, source, source.getProject()).process();
        }
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processText"));
        }
        if (rangeToReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processText"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processText"));
        }
        Language sourceLang = source.getLanguage();
        if (source.isValid() && source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && JSCommentPostFormatProcessor.shouldWrapLongLines(settings, sourceLang)) {
            TextRange textRange = new JSCommentVisitor(settings, (PsiElement)source, source.getProject()).processText(rangeToReformat);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processText"));
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "processText"));
        }
        return textRange;
    }

    private static boolean shouldWrapLongLines(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "shouldWrapLongLines"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor", "shouldWrapLongLines"));
        }
        return settings.getCommonSettings((Language)language).WRAP_COMMENTS;
    }

    private static class JSCommentVisitor
    extends JSRecursiveElementVisitor {
        private TextRange myOriginalRange;
        private final PsiElement mySource;
        private final Document myDocument;
        private int myDelta;
        private Project myProject;
        private final int myRightMargin;
        private final CommonCodeStyleSettings myJsSettings;
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

        JSCommentVisitor(@NotNull CodeStyleSettings settings, @NotNull PsiElement source, @NotNull Project project) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor$JSCommentVisitor", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor$JSCommentVisitor", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor$JSCommentVisitor", "<init>"));
            }
            this.mySource = source;
            this.myDocument = source.getContainingFile().getViewProvider().getDocument();
            this.myJsSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
            this.myIndentOptions = this.myJsSettings.getIndentOptions();
            assert (this.myIndentOptions != null);
            this.myRightMargin = settings.getRightMargin((Language)JavascriptLanguage.INSTANCE);
            this.myProject = project;
        }

        PsiElement process() {
            if (this.myDocument == null) {
                return this.mySource;
            }
            this.myOriginalRange = this.mySource.getTextRange();
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.mySource;
        }

        TextRange processText(@NotNull TextRange rangeToReformat) {
            if (rangeToReformat == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/lang/javascript/formatter/JSCommentPostFormatProcessor$JSCommentVisitor", "processText"));
            }
            if (this.myDocument == null) {
                return rangeToReformat;
            }
            this.myOriginalRange = rangeToReformat;
            this.mySource.accept((PsiElementVisitor)this);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myDocument);
            return this.myOriginalRange.grown(this.myDelta);
        }

        public void visitJSDocComment(JSDocComment docComment) {
            TextRange docRange = docComment.getTextRange();
            int start = docRange.getStartOffset() + this.myDelta;
            int end = docRange.getEndOffset() + this.myDelta;
            String newDoc = CommentWrapper.wrapCommentLines((CommentLineDataBuilder)new DocCommentLineDataBuilder((PsiElement)docComment, false, this.myJsSettings), (int)this.myRightMargin);
            if (newDoc != null) {
                int newLength = newDoc.length();
                this.myDelta += newLength - docComment.getTextLength();
                this.myDocument.replaceString(start, end, (CharSequence)newDoc);
            }
        }

        public void visitComment(PsiComment comment) {
            String replacement;
            LineCommentLineDataBuilder lineDataBuilder;
            if (comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && this.myOriginalRange.contains(comment.getTextRange()) && !(lineDataBuilder = new LineCommentLineDataBuilder(comment, JSTokenTypes.END_OF_LINE_COMMENT, this.myJsSettings, this.myOriginalRange)).isMergedWithPrevious(comment) && (replacement = CommentWrapper.wrapCommentLines((CommentLineDataBuilder)lineDataBuilder, (int)this.myRightMargin)) != null) {
                TextRange originalRange = lineDataBuilder.getCommentBlockRange();
                int start = originalRange.getStartOffset() + this.myDelta;
                int end = originalRange.getEndOffset() + this.myDelta;
                this.myDocument.replaceString(start, end, (CharSequence)replacement);
                this.myDelta += replacement.length() - originalRange.getLength();
            }
        }
    }
}

