/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBinaryOperatorAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final IElementType myOperatorType;
    private final CommonCodeStyleSettings myJSCommonSettings;
    private final Alignment myAlignment;

    @Nullable
    public static JSBinaryOperatorAlignmentFactory getInstance(@NotNull ASTNode binaryExpression, @Nullable ASTNodeBasedAlignmentFactory currentFactory, @NotNull CommonCodeStyleSettings jsCommonSettings) {
        IElementType currentType;
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory", "getInstance"));
        }
        if (jsCommonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCommonSettings", "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory", "getInstance"));
        }
        IElementType binaryOperatorType = JSBinaryOperatorAlignmentFactory.getBinaryOperatorType(binaryExpression);
        if (currentFactory instanceof JSBinaryOperatorAlignmentFactory && (currentType = ((JSBinaryOperatorAlignmentFactory)currentFactory).myOperatorType) == binaryOperatorType) {
            return (JSBinaryOperatorAlignmentFactory)currentFactory;
        }
        return new JSBinaryOperatorAlignmentFactory(binaryExpression, jsCommonSettings);
    }

    private JSBinaryOperatorAlignmentFactory(@NotNull ASTNode binaryExpression, @NotNull CommonCodeStyleSettings jsCommonSettings) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory", "<init>"));
        }
        if (jsCommonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCommonSettings", "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory", "<init>"));
        }
        this.myAlignment = Alignment.createAlignment();
        this.myOperatorType = JSBinaryOperatorAlignmentFactory.getBinaryOperatorType(binaryExpression);
        this.myJSCommonSettings = jsCommonSettings;
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        ASTNode parent;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSBinaryOperatorAlignmentFactory", "getAlignment"));
        }
        if (this.myJSCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION && (parent = child.getTreeParent()) != null && parent.getElementType() == JSElementTypes.BINARY_EXPRESSION) {
            return this.myAlignment;
        }
        return null;
    }

    @Nullable
    private static IElementType getBinaryOperatorType(ASTNode node) {
        if (node.getPsi() instanceof JSBinaryExpression) {
            return ((JSBinaryExpression)node.getPsi()).getOperationSign();
        }
        return null;
    }
}

