/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.punctuation;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStylePanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class JSCodeStylePunctuationPanel
extends CodeStyleAbstractPanel {
    private static final String SINGLE_QUOTE = "single";
    private static final String DOUBLE_QUOTES = "double";
    private static final String IN_NEW_CODE = "in new code";
    private static final String ALWAYS = "always";
    private static final String USE = "Use";
    private static final String DONT_USE = "Don't use";
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private ComboBox myQuotesTypeCombobox;
    private ComboBox myEnforceQuotesCombobox;
    protected ComboBox myEnforceSemicolonsCombobox;
    private ComboBox myUseSemicolonsCombobox;
    private ComboBox myTrailingCommaComboBox;
    private boolean myInsideUpdate = false;

    public JSCodeStylePunctuationPanel(Language language, CodeStyleSettings settings, boolean showAddTrailingComma) {
        super(language, null, settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        this.addPanelToWatch(this.myPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSCodeStylePunctuationPanel.this.myInsideUpdate) {
                    JSCodeStylePunctuationPanel.this.somethingChanged();
                }
            }
        };
        this.myQuotesTypeCombobox.addItemListener(listener);
        this.myEnforceQuotesCombobox.addItemListener(listener);
        this.myEnforceSemicolonsCombobox.addItemListener(listener);
        this.myUseSemicolonsCombobox.addItemListener(listener);
        JSCodeStylePanel.initCombobox((JComboBox)this.myQuotesTypeCombobox, DOUBLE_QUOTES, SINGLE_QUOTE);
        JSCodeStylePanel.initCombobox((JComboBox)this.myEnforceQuotesCombobox, IN_NEW_CODE, ALWAYS);
        JSCodeStylePanel.initCombobox((JComboBox)this.myUseSemicolonsCombobox, USE, DONT_USE);
        JSCodeStylePanel.initCombobox((JComboBox)this.myEnforceSemicolonsCombobox, IN_NEW_CODE, ALWAYS);
        ArrayList trailingCommaOptions = ContainerUtil.newArrayList((Object[])new JSCodeStylePanel.SimpleComboboxItem[]{new JSCodeStylePanel.SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.Keep, JSBundle.message((String)"js.trailing.comma.keep", (Object[])new Object[0])), new JSCodeStylePanel.SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.Remove, JSBundle.message((String)"js.trailing.comma.remove", (Object[])new Object[0]))});
        if (showAddTrailingComma) {
            trailingCommaOptions.add(new JSCodeStylePanel.SimpleComboboxItem<JSCodeStyleSettings.TrailingCommaOption>(JSCodeStyleSettings.TrailingCommaOption.WhenMultiline, JSBundle.message((String)"js.trailing.comma.whenMultiline", (Object[])new Object[0])));
        }
        JSCodeStylePanel.initCombobox((JComboBox)this.myTrailingCommaComboBox, trailingCommaOptions);
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(this.getFileType())).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), this.getFileType(), null, scheme);
    }

    protected int getRightMargin() {
        return 60;
    }

    @NotNull
    protected abstract FileType getFileType();

    protected String getTabTitle() {
        return "Punctuation";
    }

    protected String getPreviewText() {
        return "/*\n Multiline\n C-style\n Comment\n */\nvar myLink = {\n      img: \"btn.gif\",\n      text: \"Button\",\n      width: 128\n    },\n    local = true,\n    initial = -1;\nvar cssClasses = [\"bold\", \"red\",]\nvar selector = \"#id\";\n\nvar color = \"red\";\nvar offset = 10;\n\nvarName = val;";
    }

    public void apply(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT = this.useSemicolonSelected();
        jsCodeStyleSettings.ENFORCE_TRAILING_COMMA = (JSCodeStyleSettings.TrailingCommaOption)((Object)JSCodeStylePanel.getComboboxValue((JComboBox)this.myTrailingCommaComboBox));
        jsCodeStyleSettings.USE_DOUBLE_QUOTES = this.doubleQuotesSelected();
        jsCodeStyleSettings.FORCE_QUOTE_STYlE = this.enforceQuotesSelected();
        jsCodeStyleSettings.FORCE_SEMICOLON_STYLE = this.enforceSemicolonsSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        return jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT != this.useSemicolonSelected() || jsCodeStyleSettings.ENFORCE_TRAILING_COMMA != JSCodeStylePanel.getComboboxValue((JComboBox)this.myTrailingCommaComboBox) || jsCodeStyleSettings.USE_DOUBLE_QUOTES != this.doubleQuotesSelected() || jsCodeStyleSettings.FORCE_QUOTE_STYlE != this.enforceQuotesSelected() || jsCodeStyleSettings.FORCE_SEMICOLON_STYLE != this.enforceSemicolonsSelected();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public Set<String> processListOptions() {
        HashSet options = ContainerUtil.newHashSet((Iterable)super.processListOptions());
        options.add(SINGLE_QUOTE);
        options.add(DOUBLE_QUOTES);
        options.add(ALWAYS);
        options.add(IN_NEW_CODE);
        return options;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        try {
            this.myInsideUpdate = true;
            JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
            JSCodeStylePanel.selectComboboxValue((JComboBox)this.myTrailingCommaComboBox, jsCodeStyleSettings.ENFORCE_TRAILING_COMMA);
            JSCodeStylePanel.selectComboboxValue((JComboBox)this.myQuotesTypeCombobox, jsCodeStyleSettings.USE_DOUBLE_QUOTES ? DOUBLE_QUOTES : SINGLE_QUOTE);
            JSCodeStylePanel.selectComboboxValue((JComboBox)this.myEnforceQuotesCombobox, jsCodeStyleSettings.FORCE_QUOTE_STYlE ? ALWAYS : IN_NEW_CODE);
            JSCodeStylePanel.selectComboboxValue((JComboBox)this.myEnforceSemicolonsCombobox, jsCodeStyleSettings.FORCE_SEMICOLON_STYLE ? ALWAYS : IN_NEW_CODE);
            JSCodeStylePanel.selectComboboxValue((JComboBox)this.myUseSemicolonsCombobox, jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT ? USE : DONT_USE);
        }
        finally {
            this.myInsideUpdate = false;
        }
    }

    private boolean enforceQuotesSelected() {
        return JSCodeStylePanel.getComboboxValue((JComboBox)this.myEnforceQuotesCombobox) == ALWAYS;
    }

    private boolean enforceSemicolonsSelected() {
        return JSCodeStylePanel.getComboboxValue((JComboBox)this.myEnforceSemicolonsCombobox) == ALWAYS;
    }

    protected boolean useSemicolonSelected() {
        return JSCodeStylePanel.getComboboxValue((JComboBox)this.myUseSemicolonsCombobox) == USE;
    }

    private boolean doubleQuotesSelected() {
        return JSCodeStylePanel.getComboboxValue((JComboBox)this.myQuotesTypeCombobox) == DOUBLE_QUOTES;
    }

    private JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.getDefaultLanguage()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        ComboBox comboBox5;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), "", 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("semicolon to terminate statements");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnforceSemicolonsCombobox = comboBox5 = new ComboBox();
        jPanel4.add((Component)comboBox5, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myUseSemicolonsCombobox = comboBox4 = new ComboBox();
        jPanel4.add((Component)comboBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText(USE);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuotesTypeCombobox = comboBox3 = new ComboBox();
        jPanel5.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("quotes");
        jLabel2.setDisplayedMnemonic('Q');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnforceQuotesCombobox = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 3, 1, 3, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Trailing comma:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTrailingCommaComboBox = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 5, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox4);
        jLabel.setLabelFor((Component)comboBox3);
        jLabel2.setLabelFor((Component)comboBox2);
        jBLabel2.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

