/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSAmdFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("js.amd" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdFileIncludeProvider", "getId"));
        }
        return "js.amd";
    }

    public boolean acceptFile(VirtualFile file) {
        return HtmlUtil.isHtmlFile((VirtualFile)file) && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/lang/javascript/frameworks/amd/JSAmdFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)StdFileTypes.HTML);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile instanceof XmlFile) {
            FileIncludeInfo[] fileIncludeInfoArray = JSAmdFileIncludeProvider.getIncludeInfos((XmlFile)psiFile);
            if (fileIncludeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdFileIncludeProvider", "getIncludeInfos"));
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdFileIncludeProvider", "getIncludeInfos"));
        }
        return FileIncludeInfo.EMPTY;
    }

    private static FileIncludeInfo[] getIncludeInfos(XmlFile xmlFile) {
        final ArrayList result = new ArrayList();
        xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String src;
                if ("script".equalsIgnoreCase(tag.getName()) && !StringUtil.isEmpty((String)(src = tag.getAttributeValue("data-main")))) {
                    result.add(new FileIncludeInfo(src + ".js"));
                }
                super.visitXmlTag(tag);
            }

            public void visitElement(PsiElement element) {
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }
        });
        return (FileIncludeInfo[])ContainerUtil.toArray(result, (Object[])FileIncludeInfo.EMPTY);
    }
}

