/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.lang.javascript.frameworks.extjs.ExtXTypeReference;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/frameworks/extjs/ExtReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JSLiteralExpression literalExpression = (JSLiteralExpression)element;
                if (!literalExpression.isQuotedLiteral()) {
                    return false;
                }
                PsiElement parent = literalExpression.getParent();
                if (!(parent instanceof JSProperty)) {
                    return false;
                }
                return "xtype".equals(((JSProperty)parent).getName());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/extjs/ExtReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/extjs/ExtReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new ExtXTypeReference((JSLiteralExpression)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/extjs/ExtReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

