/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.mozilla;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XulLanguageInjector
implements MultiHostInjector,
JSTargetedInjector {
    private static final Language cssLanguage = Language.findLanguageByID((String)"CSS");
    private final ImmutableList<Class<? extends XmlElement>> myElementsToInjectIn = ImmutableList.of(XmlAttributeValue.class, XmlText.class);

    public static boolean isMozillaXulOrXblNs(@NonNls String ns) {
        return "http://www.mozilla.org/xbl".equals(ns) || "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(ns);
    }

    private static String getNameFromTag(XmlTag parentTag, @NonNls String s) {
        return parentTag != null && s.equals(parentTag.getLocalName()) ? parentTag.getAttributeValue("name") : "";
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        PsiElement _tag;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/frameworks/mozilla/XulLanguageInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/mozilla/XulLanguageInjector", "getLanguagesToInject"));
        }
        if (host.isValid() && host.getContainingFile().getLanguage().is((Language)HTMLLanguage.INSTANCE)) {
            return;
        }
        if (host instanceof XmlAttributeValue) {
            PsiElement attribute = host.getParent();
            PsiElement tag = attribute.getParent();
            if (attribute instanceof XmlAttribute && tag instanceof XmlTag && tag.isValid()) {
                if (host.getTextLength() == 0) {
                    return;
                }
                if (!XulLanguageInjector.isMozillaXulOrXblNs(((XmlTag)tag).getNamespace())) {
                    return;
                }
                String attrName = ((XmlAttribute)attribute).getName();
                if (attrName.startsWith("on")) {
                    TextRange range = new TextRange(1, host.getTextLength() - 1);
                    registrar.startInjecting((Language)JavascriptLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, range).doneInjecting();
                } else if ("style".equals(attrName) && cssLanguage != null) {
                    registrar.startInjecting(cssLanguage).addPlace("inline.style {", "}", (PsiLanguageInjectionHost)host, new TextRange(1, host.getTextLength() - 1)).doneInjecting();
                }
            }
        } else if (host instanceof XmlText && (_tag = host.getParent()) instanceof XmlTag && _tag.isValid()) {
            XmlTag tag = (XmlTag)_tag;
            if (!XulLanguageInjector.isMozillaXulOrXblNs(tag.getNamespace())) {
                return;
            }
            String localName = tag.getLocalName();
            if (HtmlUtil.isScriptTag((XmlTag)tag) && !(tag instanceof HtmlTag)) {
                JavascriptLanguage language = JavascriptLanguage.INSTANCE;
                JSLanguageInjector.injectToXmlText(registrar, host, (Language)language, null, null);
            } else {
                boolean setter = false;
                boolean field = false;
                boolean body = false;
                boolean handler = false;
                boolean constructor = false;
                boolean getter = "getter".equals(localName);
                if (getter || (setter = "setter".equals(localName)) || (field = "field".equals(localName)) || (body = "body".equals(localName)) || (handler = "handler".equals(localName)) || (constructor = "constructor".equals(localName))) {
                    String prefix = null;
                    String suffix = null;
                    if (getter || setter) {
                        String name = XulLanguageInjector.getNameFromTag(tag.getParentTag(), "property");
                        prefix = "function " + (getter ? "get " : "set ") + name + "(" + (setter ? "val" : "") + ") {";
                        suffix = "}";
                    } else if (body) {
                        XmlTag parentTag = tag.getParentTag();
                        String name = XulLanguageInjector.getNameFromTag(parentTag, "method");
                        String signature = "";
                        for (XmlTag ptag : parentTag.findSubTags("parameter")) {
                            if (signature.length() > 0) {
                                signature = signature + ", ";
                            }
                            signature = signature + ptag.getAttributeValue("name");
                        }
                        prefix = "function " + name + "(" + signature + ") {";
                        suffix = "}";
                    } else if (field) {
                        prefix = "var " + tag.getAttributeValue("name") + " = ";
                    } else if (handler) {
                        prefix = "function " + tag.getAttributeValue("event") + "() {";
                        suffix = "}";
                    } else if (constructor) {
                        XmlTag parentTag = tag.getParentTag();
                        XmlTag grandParentTag = parentTag != null ? parentTag.getParentTag() : null;
                        prefix = "function " + (grandParentTag != null ? grandParentTag.getAttributeValue("id") : null) + "() {";
                        suffix = "}";
                    }
                    JSLanguageInjector.injectToXmlText(registrar, host, (Language)JavascriptLanguage.INSTANCE, prefix, suffix);
                }
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        ImmutableList<Class<? extends XmlElement>> immutableList = this.myElementsToInjectIn;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/mozilla/XulLanguageInjector", "elementsToInjectIn"));
        }
        return immutableList;
    }
}

